/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.stypes;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Vector;
import transbase.tbx.TBStreamInterface;
import transbase.tbx.TBXConnectionIf;
import transbase.tbx.stypes.TBInteger;
import transbase.tbx.stypes.TBType;
import transbase.tbx.stypes.TBTypeBu;
import transbase.tbx.stypes.TBTypeQd;
import transbase.tbx.stypes.TBTypeSh;
import transbase.tbx.tuple.TBTuple;

public class TBTypeTb
implements TBStreamInterface,
TBType {
    private TBTypeSh eod;
    private TBInteger high;
    private TBInteger low;
    private TBTypeBu buffer;
    private TBXConnectionIf mConnection = null;

    public TBTypeTb() {
        this.eod = new TBTypeSh();
        this.high = new TBInteger();
        this.low = new TBInteger();
        this.buffer = new TBTypeBu();
    }

    public TBTypeTb(byte[] byArray) {
        this.eod = new TBTypeSh(0);
        this.buffer = new TBTypeBu(byArray);
        this.high = new TBInteger(byArray.length);
        this.low = new TBInteger(0);
    }

    public boolean isEod() {
        return this.eod.getValue() != 0;
    }

    public Vector getTupleVector(TBTypeQd tBTypeQd, int n) throws SQLException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.buffer.getValue());
        Vector<TBTuple> vector = new Vector<TBTuple>(1, 30);
        try {
            while (((InputStream)byteArrayInputStream).available() > 0) {
                vector.addElement(new TBTuple(tBTypeQd, byteArrayInputStream, this.mConnection, n));
            }
        }
        catch (IOException iOException) {
            throw new SQLException("Error while getting TupleVector: ".concat(String.valueOf(String.valueOf(iOException.getMessage()))));
        }
        return vector;
    }

    public String getLogString(TBXConnectionIf tBXConnectionIf) {
        return String.valueOf(String.valueOf(new StringBuffer("Tb(").append(this.eod.getLogString(tBXConnectionIf)).append(", ").append(this.high.getLogString(tBXConnectionIf)).append(", ").append(this.low.getLogString(tBXConnectionIf)).append(", ").append(this.buffer.getLogString(tBXConnectionIf)).append(")")));
    }

    public void readTBStream(DataInput dataInput, TBXConnectionIf tBXConnectionIf) throws SQLException, IOException {
        this.mConnection = tBXConnectionIf;
        this.eod.readTBStream(dataInput, tBXConnectionIf);
        this.high.readTBStream(dataInput, tBXConnectionIf);
        this.low.readTBStream(dataInput, tBXConnectionIf);
        this.buffer.readTBStream(dataInput, tBXConnectionIf);
    }

    public void writeTBStream(DataOutput dataOutput, TBXConnectionIf tBXConnectionIf) throws SQLException, IOException {
        this.mConnection = tBXConnectionIf;
        this.eod.writeTBStream(dataOutput, tBXConnectionIf);
        this.high.writeTBStream(dataOutput, tBXConnectionIf);
        this.low.writeTBStream(dataOutput, tBXConnectionIf);
        this.buffer.writeTBStream(dataOutput, tBXConnectionIf);
    }
}

