/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.tuple;

import java.sql.SQLException;
import transbase.tbx.TBException;
import transbase.tbx.TBXConnectionIf;
import transbase.tbx.tuple.TBAttribute;
import transbase.tbx.types.helpers.TBObject;

public abstract class TBAttr
implements TBAttribute {
    protected TBXConnectionIf mConnection;

    public TBAttr() {
    }

    public TBAttr(TBXConnectionIf tBXConnectionIf) throws SQLException {
        this.setConnection(tBXConnectionIf);
    }

    public void setConnection(TBXConnectionIf tBXConnectionIf) {
        this.mConnection = tBXConnectionIf;
    }

    public boolean isNull() throws SQLException {
        return this.getValue().isNull();
    }

    public int getTBType() throws SQLException {
        return this.getValue().getTBType();
    }

    protected int unsignedInt(byte by) {
        return by & 0xFF;
    }

    protected int toInteger(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = n2 - n;
        for (int i = n; i <= n2; ++i) {
            n3 += this.unsignedInt(byArray[i]) << --n4;
        }
        return n3;
    }

    protected short toShort(byte[] byArray, int n, int n2) {
        return (short)this.toInteger(byArray, n, n2);
    }

    protected byte[] expandByBytes(byte[] byArray, int n) {
        byte[] byArray2 = new byte[byArray.length + n];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    protected int readInteger(byte[] byArray, int n) throws SQLException {
        this.testArrayLength(byArray, n + 4);
        int n2 = this.unsignedInt(byArray[0 + n]);
        int n3 = this.unsignedInt(byArray[1 + n]);
        int n4 = this.unsignedInt(byArray[2 + n]);
        int n5 = this.unsignedInt(byArray[3 + n]);
        return (n2 << 24) + (n3 << 16) + (n4 << 8) + (n5 << 0);
    }

    protected short readShort(byte[] byArray, int n) throws SQLException {
        this.testArrayLength(byArray, n + 2);
        int n2 = this.unsignedInt(byArray[0 + n]);
        int n3 = this.unsignedInt(byArray[1 + n]);
        return (short)((n2 << 8) + (n3 << 0));
    }

    protected int readUnsignedShort(byte[] byArray, int n) throws SQLException {
        this.testArrayLength(byArray, n + 2);
        int n2 = this.unsignedInt(byArray[0 + n]);
        int n3 = this.unsignedInt(byArray[1 + n]);
        return (n2 << 8) + (n3 << 0);
    }

    protected void insertInteger(byte[] byArray, int n, int n2) throws SQLException {
        this.testArrayLength(byArray, n + 4);
        byArray[n + 0] = (byte)((n2 & 0xFF000000) >> 24);
        byArray[n + 1] = (byte)((n2 & 0xFF0000) >> 16);
        byArray[n + 2] = (byte)((n2 & 0xFF00) >> 8);
        byArray[n + 3] = (byte)((n2 & 0xFF) >> 0);
    }

    protected void insertShort(byte[] byArray, int n, short s) throws SQLException {
        this.testArrayLength(byArray, n + 2);
        byArray[n + 0] = (byte)((s & 0xFF00) >> 8);
        byArray[n + 1] = (byte)((s & 0xFF) >> 0);
    }

    protected void insertUnsignedShort(byte[] byArray, int n, int n2) throws SQLException {
        this.testArrayLength(byArray, n + 2);
        byArray[n + 0] = (byte)((n2 & 0xFF00) >> 8);
        byArray[n + 1] = (byte)((n2 & 0xFF) >> 0);
    }

    protected void testArrayLength(byte[] byArray, int n) throws SQLException {
        if (byArray.length < n) {
            throw TBException.getTBException(30005, "TBAttr");
        }
    }

    public abstract TBObject getValue() throws SQLException;

    public abstract byte[] getInternalValue() throws SQLException;
}

