/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.tuple;

import java.sql.SQLException;
import transbase.tbx.TBXConnectionIf;
import transbase.tbx.tuple.TBAttr;
import transbase.tbx.types.TypeToClass;
import transbase.tbx.types.helpers.TBObject;

public class TBAttrInteger
extends TBAttr {
    private TBObject mValue;

    public TBAttrInteger(int n) throws SQLException {
        this.mValue = TypeToClass.getInstance(n);
    }

    public TBAttrInteger(TBObject tBObject) throws SQLException {
        this.mValue = tBObject;
    }

    public TBObject getValue() throws SQLException {
        return this.mValue;
    }

    public TBAttrInteger(TBXConnectionIf tBXConnectionIf, byte[] byArray, int n) throws SQLException {
        super(tBXConnectionIf);
        int n2;
        this.mValue = TypeToClass.getInstance(n);
        if (byArray == null || byArray.length == 0) {
            return;
        }
        switch (n) {
            case 5: {
                n2 = 1;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
            default: {
                n2 = 4;
            }
        }
        if (byArray.length < n2) {
            throw new SQLException("Not enough bytes on Stream for TBAttrInteger");
        }
        switch (n) {
            case 5: {
                this.mValue.setByte(byArray[0]);
                break;
            }
            case 6: {
                this.mValue.setShort(this.readShort(byArray, 0));
                break;
            }
            case 1: {
                this.mValue.setInt(this.readInteger(byArray, 0));
            }
        }
        this.mValue.setCharEncoding(tBXConnectionIf.getCharEncodingFactory());
    }

    public byte[] getInternalValue() throws SQLException {
        byte[] byArray;
        if (this.isNull()) {
            byArray = new byte[]{};
        } else {
            switch (this.getTBType()) {
                case 1: {
                    byArray = new byte[4];
                    this.insertInteger(byArray, 0, this.mValue.getInt());
                    break;
                }
                case 6: {
                    byArray = new byte[2];
                    this.insertShort(byArray, 0, this.mValue.getShort());
                    break;
                }
                case 5: {
                    byArray = new byte[]{this.mValue.getByte()};
                    break;
                }
                default: {
                    byArray = new byte[]{};
                }
            }
        }
        return byArray;
    }
}

