/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.types;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import transbase.tbx.TBException;
import transbase.tbx.types.helpers.TBObjectBase;

public class TBBinchar
extends TBObjectBase {
    private byte[] value = null;

    public boolean isNull() throws SQLException {
        return this.value == null;
    }

    public void setNull() throws SQLException {
        this.value = null;
    }

    public int getTBType() {
        return 12;
    }

    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getCharEncoding().getString(this.value);
    }

    public byte[] getBytes() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        byte[] byArray = new byte[this.value.length];
        System.arraycopy(this.value, 0, byArray, 0, this.value.length);
        return byArray;
    }

    public InputStream getAsciiStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getCharEncoding().getASCIIStream(this.getBinaryStream());
    }

    public InputStream getUnicodeStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getCharEncoding().getUnicodeStream(this.getBinaryStream());
    }

    public InputStream getBinaryStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new ByteArrayInputStream(this.getBytes());
    }

    public void setString(String string) throws SQLException {
        this.value = (byte[])(string == null ? null : this.getCharEncoding().getBytes(string));
    }

    public void setBytes(byte[] byArray) throws SQLException {
        if (byArray == null) {
            this.value = null;
        } else {
            this.value = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.value, 0, byArray.length);
        }
    }

    public void setAsciiStream(InputStream inputStream, int n) throws SQLException {
        if (inputStream == null) {
            this.value = null;
        } else {
            this.setBinaryStream(this.getCharEncoding().getASCIIToByteStream(inputStream), -1);
        }
    }

    public void setUnicodeStream(InputStream inputStream, int n) throws SQLException {
        if (inputStream == null) {
            this.value = null;
        } else {
            this.setBinaryStream(this.getCharEncoding().getUnicodeToByteStream(inputStream), -1);
        }
    }

    public void setBinaryStream(InputStream inputStream, int n) throws SQLException {
        if (inputStream == null) {
            this.value = null;
        } else {
            int n2 = 0;
            byte[] byArray = new byte[2048];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                while ((n2 = inputStream.read(byArray)) > 0) {
                    byteArrayOutputStream.write(byArray, 0, n2);
                }
            }
            catch (IOException iOException) {
                throw TBException.getTBException(30012, new String[]{this.toString(), "setBinaryStream: ".concat(String.valueOf(String.valueOf(iOException.getMessage())))});
            }
            this.value = byteArrayOutputStream.toByteArray();
        }
    }
}

