/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.types;

import java.sql.SQLException;
import transbase.tbx.TBConst;
import transbase.tbx.TBException;
import transbase.tbx.types.helpers.TBObjectBase;

public class TBBits
extends TBObjectBase {
    private int length = 0;
    private byte[] value = new byte[0];
    private boolean isNull = true;
    private int mSubType;

    public TBBits() throws SQLException {
        this.setSubType(14);
    }

    public TBBits(int n) throws SQLException {
        this.setSubType(n);
    }

    public TBBits(int n, int n2, byte[] byArray) throws SQLException {
        this.setSubType(n);
        this.length = n2;
        this.value = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.value, 0, byArray.length);
        this.isNull = false;
    }

    private void testIndex(int n) throws SQLException {
        int n2 = this.getSubType();
        if (n < 0 || n2 == 30 && n > 65535) {
            throw TBException.getTBException(30003, Integer.toString(n));
        }
    }

    private void setSubType(int n) throws SQLException {
        if (n != 14 && n != 30) {
            throw TBException.getTBException(30212, new String[]{TBConst.getTBTypeName(n), TBConst.getTBTypeName(14)});
        }
        this.mSubType = n;
    }

    public int getSubType() {
        return this.mSubType;
    }

    public boolean isNull() throws SQLException {
        return this.isNull;
    }

    public void setNull() throws SQLException {
        this.isNull = true;
        this.length = 0;
        this.value = new byte[0];
    }

    public int getTBType() {
        return this.mSubType;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getBitArray() {
        if (this.isNull) {
            return null;
        }
        return this.value;
    }

    public int testBit(int n) throws SQLException {
        this.testIndex(n);
        if (n >= this.length) {
            return 0;
        }
        return (this.value[n / 8] & 128 >> n % 8) != 0 ? 1 : 0;
    }

    public void addSingleBit(int n) throws SQLException {
        this.testIndex(n);
        this.isNull = false;
        if (n >= this.length) {
            byte[] byArray = new byte[(n + 8) / 8];
            System.arraycopy(this.value, 0, byArray, 0, this.value.length);
            this.value = byArray;
            this.length = n + 1;
        }
        int n2 = n / 8;
        this.value[n2] = (byte)(this.value[n2] | 128 >> n % 8);
    }

    public void delSingleBit(int n) throws SQLException {
        this.testIndex(n);
        this.isNull = false;
        if (n < this.length) {
            int n2 = n / 8;
            this.value[n2] = (byte)(this.value[n2] & ~(128 >> n % 8));
            this.trimArray();
        }
    }

    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.length; ++i) {
            stringBuffer.append(this.testBit(i));
        }
        return stringBuffer.toString();
    }

    public int getMaxBitPos() {
        for (int i = this.value.length - 1; i >= 0; --i) {
            if (this.value[i] == 0) continue;
            for (int j = 0; j < 8; ++j) {
                if ((this.value[i] & 1 << j) == 0) continue;
                return i * 8 + (7 - j);
            }
        }
        return -1;
    }

    private void trimArray() {
        this.length = this.getMaxBitPos() + 1;
        byte[] byArray = new byte[(this.length + 7) / 8];
        System.arraycopy(this.value, 0, byArray, 0, byArray.length);
        this.value = byArray;
    }
}

