/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import transbase.tbx.TBException;
import transbase.tbx.TBXCursor;
import transbase.tbx.types.helpers.BlobStream;
import transbase.tbx.types.helpers.TBObjectBase;

public class TBBlob
extends TBObjectBase {
    private BlobStream value = null;

    public TBBlob() {
    }

    public TBBlob(byte[] byArray) throws SQLException {
        this.setBytes(byArray);
    }

    public void setCursor(TBXCursor tBXCursor) {
        if (this.value != null) {
            this.value.setCursor(tBXCursor);
        }
    }

    public boolean isNull() throws SQLException {
        return this.value == null;
    }

    public void setNull() throws SQLException {
        this.value = null;
    }

    public int getTBType() {
        return 13;
    }

    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getCharEncoding().getString(this.getBytes());
    }

    public byte[] getBytes() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        byte[] byArray = null;
        try {
            byArray = this.value.getByteArray();
        }
        catch (IOException iOException) {
            throw TBException.getTBException(30012, new String[]{this.toString(), "getBytes: ".concat(String.valueOf(String.valueOf(iOException.getMessage())))});
        }
        return byArray;
    }

    public InputStream getAsciiStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getCharEncoding().getASCIIStream(this.getBinaryStream());
    }

    public InputStream getUnicodeStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getCharEncoding().getUnicodeStream(this.getBinaryStream());
    }

    public InputStream getBinaryStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    public BlobStream getBlobStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    public void setBlobStream(BlobStream blobStream) throws SQLException {
        this.value = blobStream;
    }

    public void setString(String string) throws SQLException {
        if (string == null) {
            this.value = null;
        } else {
            byte[] byArray = this.getCharEncoding().getBytes(string);
            this.value = new BlobStream(byArray);
        }
    }

    public void setBytes(byte[] byArray) throws SQLException {
        if (byArray == null) {
            this.value = null;
        } else {
            byte[] byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            this.value = new BlobStream(byArray2);
        }
    }

    public void setAsciiStream(InputStream inputStream, int n) throws SQLException {
        if (inputStream == null) {
            this.value = null;
        } else {
            this.setBinaryStream(this.getCharEncoding().getASCIIToByteStream(inputStream), -1);
        }
    }

    public void setUnicodeStream(InputStream inputStream, int n) throws SQLException {
        if (inputStream == null) {
            this.value = null;
        } else {
            this.setBinaryStream(this.getCharEncoding().getUnicodeToByteStream(inputStream), -1);
        }
    }

    public void setBinaryStream(InputStream inputStream, int n) throws SQLException {
        this.value = inputStream == null ? null : new BlobStream(inputStream, n);
    }

    public Reader getCharacterStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getCharEncoding().getInputStreamReader(this.value);
    }

    public void setCharacterStream(Reader reader, int n) throws SQLException {
        if (reader == null) {
            this.value = null;
        } else {
            this.setBinaryStream(this.getCharEncoding().getCharToByteStream(reader), -1);
        }
    }
}

