/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.types;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import transbase.tbx.TBException;
import transbase.tbx.types.helpers.TBTimeman;

public class TBDatetime
extends TBTimeman {
    public TBDatetime() {
    }

    public int getTBType() {
        return 8;
    }

    public TBDatetime(int n, short[] sArray) throws SQLException {
        if (sArray == null) {
            return;
        }
        this.qual = n;
        this.calculateQualFields();
        if (sArray.length > 7) {
            throw new TBException(21004);
        }
        this.initValArray();
        for (int i = 0; i < 7; ++i) {
            this.val[i] = sArray[i] & 0xFFFF;
        }
    }

    public void setString(String string) throws SQLException {
        if (string == null) {
            this.setNull();
        } else {
            string = string.trim();
            try {
                if (string.indexOf(" ") >= 0) {
                    this.setTimestamp(Timestamp.valueOf(string));
                    return;
                }
                if (string.indexOf(":") >= 0) {
                    this.setTime(Time.valueOf(string));
                    return;
                }
                if (string.indexOf("-") >= 0) {
                    this.setDate(Date.valueOf(string));
                    return;
                }
                this.setNull();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new TBException(30034);
            }
        }
    }

    public void setDate(Date date) throws SQLException {
        if (date == null) {
            this.setNull();
        } else {
            this.initValArray();
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            this.setSign(0);
            this.setLowField(4);
            this.setHighField(6);
            this.setField(6, gregorianCalendar.get(1));
            this.setField(5, gregorianCalendar.get(2) + 1);
            this.setField(4, gregorianCalendar.get(5));
        }
    }

    public void setTime(Time time) throws SQLException {
        if (time == null) {
            this.setNull();
        } else {
            this.initValArray();
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(time);
            this.setSign(0);
            this.setLowField(1);
            this.setHighField(3);
            this.setField(3, gregorianCalendar.get(11));
            this.setField(2, gregorianCalendar.get(12));
            this.setField(1, gregorianCalendar.get(13));
        }
    }

    public void setTimestamp(Timestamp timestamp) throws SQLException {
        if (timestamp == null) {
            this.setNull();
        } else {
            this.initValArray();
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(timestamp);
            gregorianCalendar.set(14, timestamp.getNanos() / 1000000);
            this.setSign(0);
            this.setLowField(0);
            this.setHighField(6);
            this.setField(6, gregorianCalendar.get(1));
            this.setField(5, gregorianCalendar.get(2) + 1);
            this.setField(4, gregorianCalendar.get(5));
            this.setField(3, gregorianCalendar.get(11));
            this.setField(2, gregorianCalendar.get(12));
            this.setField(1, gregorianCalendar.get(13));
            this.setField(0, gregorianCalendar.get(14));
        }
    }

    public static TBDatetime getFromLiteral(String string, int n) throws SQLException {
        try {
            TBDatetime tBDatetime = new TBDatetime();
            switch (n) {
                case 91: {
                    Date date = Date.valueOf(string);
                    tBDatetime.setDate(date);
                    break;
                }
                case 92: {
                    Time time = Time.valueOf(string);
                    tBDatetime.setTime(time);
                    break;
                }
                case 93: {
                    Timestamp timestamp = Timestamp.valueOf(string);
                    tBDatetime.setTimestamp(timestamp);
                    break;
                }
                default: {
                    throw new Exception("unknown Type");
                }
            }
            TBDatetime tBDatetime2 = tBDatetime;
            return tBDatetime2;
        }
        catch (Exception exception) {
            throw TBException.getTBException(30014, new String[]{string});
        }
    }

    public int getOptimalJavaType() {
        int n = this.getLowField();
        int n2 = this.getHighField();
        if (n >= 1 && n2 <= 3) {
            return 92;
        }
        if (n >= 4 && n2 <= 6) {
            return 91;
        }
        return 93;
    }

    public int getQual() {
        return this.qual;
    }

    public short[] getVal() {
        short[] sArray = new short[7];
        for (int i = 0; i < 7; ++i) {
            sArray[i] = (short)(this.val[i] & (long)65535);
        }
        return sArray;
    }

    public Timestamp getTimestamp() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n = (int)(this.isFieldContained(6) ? this.getField(6) : (long)gregorianCalendar.get(1));
        int n2 = (int)(this.isFieldContained(5) ? this.getField(5) : (long)gregorianCalendar.get(2));
        int n3 = (int)(this.isFieldContained(4) ? this.getField(4) : (long)gregorianCalendar.get(5));
        Timestamp timestamp = new Timestamp(n - 1900, n2 - 1, n3, (int)this.getField(3), (int)this.getField(2), (int)this.getField(1), (int)this.getField(0) * 1000000);
        return timestamp;
    }

    public Time getTime() throws SQLException {
        return this.getTime(Calendar.getInstance());
    }

    public Time getTime(Calendar calendar) throws SQLException {
        if (this.isNull()) {
            return null;
        }
        if (!this.isFieldContained(3) || !this.isFieldContained(1)) {
            throw new TBException(21003);
        }
        calendar.set(14, 0);
        calendar.set(1970, 0, 1, (int)this.getField(3), (int)this.getField(2), (int)this.getField(1));
        Time time = new Time(calendar.getTime().getTime());
        return time;
    }

    public Date getDate() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        if (!this.isFieldContained(4) || !this.isFieldContained(6)) {
            throw new TBException(21003);
        }
        Date date = new Date((int)this.getField(6) - 1900, (int)this.getField(5) - 1, (int)this.getField(4));
        return date;
    }

    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        int n = this.getOptimalJavaType();
        switch (n) {
            case 92: {
                return this.getTime().toString();
            }
            case 91: {
                return this.getDate().toString();
            }
        }
        return this.getTimestamp().toString();
    }

    public String getTBLiteral() {
        String string = "DATETIME [";
        int n = this.getHighField();
        int n2 = this.getLowField();
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(TBTimeman.getFieldQual(n))));
        string = String.valueOf(String.valueOf(string)).concat(":");
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(TBTimeman.getFieldQual(n2))));
        string = String.valueOf(String.valueOf(string)).concat("] (");
        block6: for (int i = n; i >= n2; --i) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(this.getField(i))));
            if (i <= n2) continue;
            switch (i) {
                case 5: 
                case 6: {
                    string = String.valueOf(String.valueOf(string)).concat("-");
                    continue block6;
                }
                case 4: {
                    string = String.valueOf(String.valueOf(string)).concat(" ");
                    continue block6;
                }
                case 2: 
                case 3: {
                    string = String.valueOf(String.valueOf(string)).concat(":");
                    continue block6;
                }
                case 1: {
                    string = String.valueOf(String.valueOf(string)).concat(".");
                }
            }
        }
        string = String.valueOf(String.valueOf(string)).concat(") ");
        return string;
    }
}

