/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.types.helpers;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class TBCharToByteStream
extends InputStream {
    private Reader mCharStream;
    private String mEncoding = null;
    private static final int MAX_CHARACTERS = 512;
    private byte[] mByteBuffer;
    private int mBytePointer = 1;
    private int mByteCount = 0;
    private char[] mCharBuffer = new char[512];
    private IOException mEncodingException = null;

    public TBCharToByteStream(Reader reader) {
        this.mCharStream = reader;
    }

    public TBCharToByteStream(Reader reader, String string) {
        this.mCharStream = reader;
        this.mEncoding = string;
    }

    public int read() throws IOException {
        int n;
        if (this.mEncodingException != null) {
            throw this.mEncodingException;
        }
        if (this.mBytePointer >= this.mByteCount) {
            n = this.mCharStream.read(this.mCharBuffer);
            if (n <= 0) {
                return -1;
            }
            String string = new String(this.mCharBuffer, 0, n);
            this.mByteBuffer = this.mEncoding == null ? string.getBytes() : string.getBytes(this.mEncoding);
            this.mBytePointer = 0;
            this.mByteCount = this.mByteBuffer.length;
        }
        n = this.mByteBuffer[this.mBytePointer];
        ++this.mBytePointer;
        return n;
    }

    public int available() throws IOException {
        return 0;
    }

    public boolean markSupported() {
        return false;
    }

    public void close() throws IOException {
        this.mCharStream.close();
    }
}

