/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.types.helpers;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import transbase.tbx.TBConst;
import transbase.tbx.TBException;
import transbase.tbx.types.helpers.CharEncodingFactory;
import transbase.tbx.types.helpers.TBObject;

public abstract class TBObjectBase
implements TBObject {
    private CharEncodingFactory mCharEncoding;

    public TBObjectBase() {
        this.setCharEncoding(CharEncodingFactory.getPlatformEncoding());
    }

    public CharEncodingFactory getCharEncoding() {
        return this.mCharEncoding;
    }

    public void setCharEncoding(CharEncodingFactory charEncodingFactory) {
        this.mCharEncoding = charEncodingFactory;
    }

    public int getTBType() {
        return 0;
    }

    public CharEncodingFactory getCharEncodingFactory() {
        return this.mCharEncoding;
    }

    public String getString() throws SQLException {
        throw this.readException(this.getTBType(), null, "java.lang.String");
    }

    public boolean getBoolean() throws SQLException {
        throw this.readException(this.getTBType(), null, "boolean");
    }

    public byte getByte() throws SQLException {
        long l = this.getLong();
        if (l > (long)127 || l < (long)-128) {
            throw new TBException(30034);
        }
        return (byte)l;
    }

    public short getShort() throws SQLException {
        long l = this.getLong();
        if (l > (long)Short.MAX_VALUE || l < (long)Short.MIN_VALUE) {
            throw new TBException(30034);
        }
        return (short)l;
    }

    public int getInt() throws SQLException {
        long l = this.getLong();
        if (l > (long)Integer.MAX_VALUE || l < (long)Integer.MIN_VALUE) {
            throw new TBException(30034);
        }
        return (int)l;
    }

    public long getLong() throws SQLException {
        throw this.readException(this.getTBType(), null, "long");
    }

    public float getFloat() throws SQLException {
        throw this.readException(this.getTBType(), null, "float");
    }

    public double getDouble() throws SQLException {
        throw this.readException(this.getTBType(), null, "double");
    }

    public BigDecimal getBigDecimal() throws SQLException {
        throw this.readException(this.getTBType(), null, "java.math.BigDecimal");
    }

    public byte[] getBytes() throws SQLException {
        throw this.readException(this.getTBType(), null, "byte[]");
    }

    public Date getDate() throws SQLException {
        throw this.readException(this.getTBType(), null, "java.sql.Date");
    }

    public Time getTime() throws SQLException {
        throw this.readException(this.getTBType(), null, "java.sql.Time");
    }

    public Time getTime(Calendar calendar) throws SQLException {
        throw this.readException(this.getTBType(), null, "java.sql.Time");
    }

    public Timestamp getTimestamp() throws SQLException {
        throw this.readException(this.getTBType(), null, "java.sql.Timestamp");
    }

    public InputStream getAsciiStream() throws SQLException {
        throw this.readException(this.getTBType(), null, "AsciiStream");
    }

    public InputStream getUnicodeStream() throws SQLException {
        throw this.readException(this.getTBType(), null, "UnicodeStream");
    }

    public InputStream getBinaryStream() throws SQLException {
        throw this.readException(this.getTBType(), null, "BinaryStream");
    }

    public Reader getCharacterStream() throws SQLException {
        throw this.readException(this.getTBType(), null, "CharacterStream");
    }

    public Ref getRef() throws SQLException {
        throw this.readException(this.getTBType(), null, "Ref");
    }

    public Blob getBlob() throws SQLException {
        throw this.readException(this.getTBType(), null, "Blob");
    }

    public Clob getClob() throws SQLException {
        throw this.readException(this.getTBType(), null, "Clob");
    }

    public Array getArray() throws SQLException {
        throw this.readException(this.getTBType(), null, "Array");
    }

    public void setBoolean(boolean bl) throws SQLException {
        throw this.writeException("boolean", this.getTBType(), null);
    }

    public void setByte(byte by) throws SQLException {
        this.setLong(by);
    }

    public void setShort(short s) throws SQLException {
        this.setLong(s);
    }

    public void setInt(int n) throws SQLException {
        this.setLong(n);
    }

    public void setLong(long l) throws SQLException {
        throw this.writeException("long", this.getTBType(), null);
    }

    public void setFloat(float f) throws SQLException {
        throw this.writeException("float", this.getTBType(), null);
    }

    public void setDouble(double d) throws SQLException {
        throw this.writeException("double", this.getTBType(), null);
    }

    public void setBigDecimal(BigDecimal bigDecimal) throws SQLException {
        throw this.writeException("java.math.BigDecimal", this.getTBType(), null);
    }

    public void setString(String string) throws SQLException {
        throw this.writeException("java.lang.String", this.getTBType(), null);
    }

    public void setBytes(byte[] byArray) throws SQLException {
        throw this.writeException("byte[]", this.getTBType(), null);
    }

    public void setDate(Date date) throws SQLException {
        throw this.writeException("java.sql.Date", this.getTBType(), null);
    }

    public void setTime(Time time) throws SQLException {
        throw this.writeException("java.sql.Time", this.getTBType(), null);
    }

    public void setTimestamp(Timestamp timestamp) throws SQLException {
        throw this.writeException("java.sql.Timestamp", this.getTBType(), null);
    }

    public void setAsciiStream(InputStream inputStream, int n) throws SQLException {
        throw this.writeException("AsciiStream", this.getTBType(), null);
    }

    public void setUnicodeStream(InputStream inputStream, int n) throws SQLException {
        throw this.writeException("UnicodeStream", this.getTBType(), null);
    }

    public void setBinaryStream(InputStream inputStream, int n) throws SQLException {
        throw this.writeException("BinaryStream", this.getTBType(), null);
    }

    public void setCharacterStream(Reader reader, int n) throws SQLException {
        throw this.writeException("CharacterStream", this.getTBType(), null);
    }

    public void setRef(Ref ref) throws SQLException {
        throw this.writeException("Ref", this.getTBType(), null);
    }

    public void setBlob(Blob blob) throws SQLException {
        throw this.writeException("Blob", this.getTBType(), null);
    }

    public void setClob(Clob clob) throws SQLException {
        throw this.writeException("Clob", this.getTBType(), null);
    }

    public void setArray(Array array) throws SQLException {
        throw this.writeException("Array", this.getTBType(), null);
    }

    protected TBException readException(int n, String string, String string2) {
        return TBException.getTBException(30033, new String[]{String.valueOf(String.valueOf(TBConst.getTBTypeName(n))).concat(String.valueOf(String.valueOf(string == null ? "" : string))), string2});
    }

    protected TBException writeException(String string, int n, String string2) {
        return TBException.getTBException(30033, new String[]{string, String.valueOf(String.valueOf(TBConst.getTBTypeName(n))).concat(String.valueOf(String.valueOf(string2 == null ? "" : string2)))});
    }

    public abstract void setNull() throws SQLException;

    public abstract boolean isNull() throws SQLException;
}

