/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.types.helpers;

import java.sql.SQLException;
import transbase.tbx.types.helpers.TBObjectBase;

public abstract class TBTimeman
extends TBObjectBase {
    public static final int MAXQUAL = 7;
    public static final short UNSIGNEDS = 0;
    public static final short PLUSS = 1;
    public static final short MINUSS = 2;
    public static final short JULS = 3;
    public static final short GREGS = 4;
    public static final short TB__MS = 0;
    public static final short TB__SS = 1;
    public static final short TB__MI = 2;
    public static final short TB__HH = 3;
    public static final short TB__DD = 4;
    public static final short TB__MO = 5;
    public static final short TB__YY = 6;
    public static final short TB__WEEKDAY = 7;
    public static final short TB__UNDEFRANGE = 8;
    private static final int LOWFMASK = 15;
    private static final int HIGHFMASK = 240;
    private static final int SIGNMASK = 3840;
    protected static final String[] DT_QUAL_NAMES = new String[]{"ms", "ss", "mi", "hh", "dd", "mo", "yy", "weekday"};
    private int lowField;
    private int highField;
    protected int qual = 0;
    protected long[] val = null;

    protected void initValArray() {
        this.val = new long[7];
    }

    public boolean isNull() throws SQLException {
        return this.val == null;
    }

    public void setNull() throws SQLException {
        this.val = null;
        this.qual = 0;
        this.calculateQualFields();
    }

    public TBTimeman() {
        this.calculateQualFields();
    }

    protected void calculateQualFields() {
        this.lowField = this.qual & 0xF;
        this.highField = (this.qual & 0xF0) >> 4;
    }

    public int getLowField() {
        return this.lowField;
    }

    protected void setLowField(int n) {
        this.lowField = n;
        this.qual &= 0xFFFFFFF0;
        this.qual |= n & 0xF;
    }

    public int getHighField() {
        return this.highField;
    }

    protected void setHighField(int n) {
        this.highField = n;
        this.qual &= 0xFFFFFF0F;
        this.qual |= n << 4 & 0xF0;
    }

    public int getSign() {
        return (this.qual & 0xF00) >> 8;
    }

    protected void setSign(int n) {
        this.qual &= 0xFFFFF0FF;
        this.qual |= n << 8 & 0xF00;
    }

    public boolean isFieldContained(int n) {
        return this.lowField <= n && this.highField >= n;
    }

    public long getField(int n) {
        return this.isFieldContained(n) ? this.val[n - this.getLowField()] : 0L;
    }

    public void setField(int n, long l) {
        if (this.isFieldContained(n)) {
            this.val[n - this.getLowField()] = l;
        }
    }

    public static String getFieldQual(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "MS";
                break;
            }
            case 2: {
                string = "MI";
                break;
            }
            case 1: {
                string = "SS";
                break;
            }
            case 3: {
                string = "HH";
                break;
            }
            case 4: {
                string = "DD";
                break;
            }
            case 5: {
                string = "MO";
                break;
            }
            case 6: {
                string = "YY";
                break;
            }
            default: {
                string = "XX";
            }
        }
        return string;
    }
}

