/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.types.info;

import transbase.tbx.types.TypeInfo;
import transbase.tbx.types.helpers.TSpec;

public class TBBincharInfo
extends TypeInfo {
    private static final String BINCHAR_TYPEQUALIFIER = "(*)";

    public TBBincharInfo(TSpec tSpec) {
        super(tSpec);
    }

    public int getTypeCode() {
        return 12;
    }

    public int getPrecision() {
        if (this.mTypeSpec == null) {
            return this.getMaxprec();
        }
        short s = this.mTypeSpec.getStrPrec();
        if (s == 0) {
            return 4000;
        }
        return s;
    }

    public int getMaxprec() {
        if (this.mTypeSpec == null) {
            return 4000;
        }
        return this.mTypeSpec.getStrPrec();
    }

    public String getLiteralPrefix() {
        return "0x";
    }

    public String getLiteralSuffix() {
        return "";
    }

    public String getCreateParams() {
        if (this.mTypeSpec == null) {
            return "";
        }
        if (this.mTypeSpec.getStrPrec() == 0) {
            return BINCHAR_TYPEQUALIFIER;
        }
        return String.valueOf(String.valueOf(new StringBuffer("(").append(this.getPrecision()).append(")")));
    }

    public boolean getCaseSensitive() {
        return true;
    }

    public int getSearchable() {
        return 2;
    }

    public boolean getUnsignedAttribute() {
        return true;
    }

    public boolean getFixedPrecScale() {
        return false;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getNumPrecRadix() {
        return 10;
    }

    public String getTypeColSizeExpr(String string) {
        String string2 = String.valueOf(String.valueOf(new StringBuffer(" substring(").append(string).append(" from (position('(' in ").append(string).append(")+1) for (position(')' in ").append(string).append(") - (position('(' in ").append(string).append(")+1))) ")));
        String string3 = String.valueOf(String.valueOf(new StringBuffer("(case when (").append(string2).append(" = '*' ) then ").append(this.getMaxprec()).append(" else ").append(string2).append(" cast integer end) ")));
        return string3;
    }
}

