/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.types.info;

import transbase.tbx.types.TypeInfo;
import transbase.tbx.types.helpers.TSpec;

public class TBCharBaseInfo
extends TypeInfo {
    private static final String CHAR_DELIMITER = "'";
    private static final String CHAR_TYPEQUALIFIER = "(*)";
    private int mTransBaseType;

    public TBCharBaseInfo(TSpec tSpec, int n) {
        super(tSpec);
        this.mTransBaseType = n;
    }

    public int getTypeCode() {
        return this.mTransBaseType;
    }

    public int getPrecision() {
        if (this.mTypeSpec == null) {
            return this.getMaxprec();
        }
        short s = this.mTypeSpec.getStrPrec();
        if (s == 0) {
            return 4000;
        }
        return s;
    }

    public int getMaxprec() {
        if (this.mTypeSpec == null || this.mTypeSpec.getStrPrec() == 0) {
            return 4000;
        }
        return this.mTypeSpec.getStrPrec();
    }

    public String getLiteralPrefix() {
        return CHAR_DELIMITER;
    }

    public String getLiteralSuffix() {
        return CHAR_DELIMITER;
    }

    public String getCreateParams() {
        if (this.mTypeSpec == null) {
            return "";
        }
        if (this.mTypeSpec.getStrPrec() == 0) {
            return CHAR_TYPEQUALIFIER;
        }
        return String.valueOf(String.valueOf(new StringBuffer("(").append(this.getPrecision()).append(")")));
    }

    public boolean getCaseSensitive() {
        return true;
    }

    public int getSearchable() {
        return 3;
    }

    public boolean getUnsignedAttribute() {
        return true;
    }

    public boolean getFixedPrecScale() {
        return false;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getNumPrecRadix() {
        return 10;
    }

    public String getTypeColSizeExpr(String string) {
        String string2 = String.valueOf(String.valueOf(new StringBuffer(" substring(").append(string).append(" from (position('(' in ").append(string).append(")+1) for (position(')' in ").append(string).append(") - (position('(' in ").append(string).append(")+1))) ")));
        String string3 = String.valueOf(String.valueOf(new StringBuffer("(case when (").append(string2).append(" = '*' ) then ").append(this.getMaxprec()).append(" else ").append(string2).append(" cast integer end) ")));
        return string3;
    }
}

