/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.ka;

import com.bmw.gki.ka.AnalyzeException;
import com.bmw.gki.ka.KeyAnalyzer;
import com.bmw.gki.ka.TechnicalException;
import com.bmw.gki.ka.analyze.AnalyzeComponentImpl;
import com.bmw.gki.ka.analyze.WriterComponentIFImpl;
import com.bmw.gki.ka.jaxp.keyformat.Keyformat;
import com.bmw.gki.ka.keydata.KeyDataTo;
import com.bmw.gki.ka.util.ConfigurationManager;
import com.bmw.gki.logging.GKILogManager;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.Locale;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyAnalyzerImpl
implements KeyAnalyzer {
    private static final Log LOG;

    private static void printClassLocation(Class<KeyAnalyzerImpl> clazz) {
        try {
            CodeSource codeSource;
            ProtectionDomain protectionDomain = clazz.getProtectionDomain();
            if (protectionDomain != null && (codeSource = protectionDomain.getCodeSource()) != null) {
                URL location = codeSource.getLocation();
                System.out.println("********************************************************************************************\nlocation of " + clazz + " -> " + location + "\n********************************************************************************************");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public KeyAnalyzerImpl() {
        this.init();
    }

    public KeyDataTo analyze(byte[] keyData) throws AnalyzeException {
        LOG.debug((Object)"analyze byte[]");
        KeyDataTo data = null;
        if (keyData != null) {
            AnalyzeComponentImpl comp = new AnalyzeComponentImpl();
            data = comp.createKeyData(keyData);
        }
        return data;
    }

    public KeyDataTo analyzeHex(String codedKeyData) throws AnalyzeException {
        LOG.debug((Object)"analyze hex");
        char[] charArr = codedKeyData.toCharArray();
        KeyDataTo data = null;
        try {
            byte[] keyData = Hex.decodeHex((char[])charArr);
            AnalyzeComponentImpl comp = new AnalyzeComponentImpl();
            data = comp.createKeyData(keyData);
        }
        catch (DecoderException e) {
            String message = "cannot decode from  hex to byte array";
            LOG.warn((Object)message, (Throwable)e);
            throw new TechnicalException(message, (Throwable)e);
        }
        return data;
    }

    public KeyDataTo analyzeBase64(String codedKeyData) throws AnalyzeException {
        LOG.debug((Object)"analyze base64");
        KeyDataTo data = null;
        try {
            AnalyzeComponentImpl comp = new AnalyzeComponentImpl();
            byte[] byteArr = codedKeyData.getBytes();
            byte[] decArr = Base64.decodeBase64((byte[])byteArr);
            data = comp.createKeyData(decArr);
        }
        catch (Exception e) {
            String message = "cannot decode from  base64 to byte array";
            LOG.warn((Object)message, (Throwable)e);
            throw new TechnicalException(message, (Throwable)e);
        }
        return data;
    }

    public byte[] writeKeyValue(String uid, String value, byte[] keyToWrite) throws AnalyzeException {
        LOG.debug((Object)"write byte[]");
        byte[] newContent = null;
        if (keyToWrite != null && uid != null && value != null) {
            try {
                AnalyzeComponentImpl aComp = new AnalyzeComponentImpl();
                Keyformat keyFormat = aComp.retrieveKeyFormat(Hex.encodeHex((byte[])keyToWrite));
                WriterComponentIFImpl wComp = new WriterComponentIFImpl();
                newContent = wComp.writeKeyValue(uid, value, keyFormat, keyToWrite);
            }
            catch (Exception e) {
                String message = "cannot write to byte array";
                LOG.warn((Object)message, (Throwable)e);
                throw new TechnicalException(message, (Throwable)e);
            }
        } else {
            newContent = keyToWrite;
        }
        return newContent;
    }

    public void setLocale(Locale newLocale) {
    }

    public void generateDisplayValues(boolean generate) {
    }

    public List<?> getInvalidFields() {
        return null;
    }

    public String createXML(KeyDataTo keyDataTo) {
        return null;
    }

    private void init() {
        ConfigurationManager manager = ConfigurationManager.getInstance();
        manager.load("key_analyzer.properties");
    }

    static {
        KeyAnalyzerImpl.printClassLocation(KeyAnalyzerImpl.class);
        LOG = GKILogManager.getInstance().getLogger(KeyAnalyzerImpl.class);
    }
}

