/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.ka.analyze;

import com.bmw.gki.ka.AnalyzeException;
import com.bmw.gki.ka.analyze.AnalyzeComponentIF;
import com.bmw.gki.ka.analyze.ProcessorBuilder;
import com.bmw.gki.ka.dao.XMLReader;
import com.bmw.gki.ka.jaxp.keyformat.Keyformat;
import com.bmw.gki.ka.jaxp.keyformatconfig.KeyFormatsConfig;
import com.bmw.gki.ka.jaxp.keyformatconfig.TypeKeyFormatConfig;
import com.bmw.gki.ka.keydata.KeyDataTo;
import com.bmw.gki.ka.keydataimpl.KeyDataToImpl;
import com.bmw.gki.ka.util.Cache;
import com.bmw.gki.ka.util.PreProdHolder;
import com.bmw.gki.ka.util.PreProdLogEntry;
import com.bmw.gki.ka.util.PreProdLogMessages;
import com.bmw.gki.logging.GKILogManager;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyzeComponentImpl
implements AnalyzeComponentIF {
    private static final Log LOG = GKILogManager.getInstance().getLogger(AnalyzeComponentImpl.class);
    private static final String KEY_CONFIGURATION_CACHE = "KEY_CONFIGURATION_CACHE";
    private static final String KEY_CONFIGURATION = "KEY_CONFIGURATION";
    private static Cache keyConfigurationCache = new Cache("KEY_CONFIGURATION_CACHE");
    private boolean keyIsTruncated;

    @Override
    public Keyformat retrieveKeyFormat(char[] hexDataArr) throws AnalyzeException {
        LOG.debug((Object)"retrieve the key format");
        String hexData = new StringBuffer().append(hexDataArr).toString().toUpperCase();
        KeyFormatsConfig keyConfig = this.getKeyFormatConfig();
        List<TypeKeyFormatConfig> configs = keyConfig.getKeyFormatConfig();
        String keyFormatName = this.getKeyFormatName(hexData, configs, true);
        if (keyFormatName == null) {
            String message;
            if (PreProdHolder.getIsPreProd()) {
                LOG.info((Object)"Pre Production modus ist set, try to get key format file without checking length");
                message = PreProdLogMessages.getParameterString("CODE_KEY_FORMAT_LENGTH", null);
                PreProdHolder.addLogEntry(new PreProdLogEntry("INFO", "CODE_KEY_FORMAT_LENGTH", message));
                keyFormatName = this.getKeyFormatName(hexData, configs, false);
                if (keyFormatName != null) {
                    message = PreProdLogMessages.getParameterString("CODE_KEY_FORMAT_MATCH", new Object[]{keyFormatName});
                    PreProdHolder.addLogEntry(new PreProdLogEntry("INFO", "CODE_KEY_FORMAT_MATCH", message));
                    LOG.info((Object)("identified keyFormatName: " + keyFormatName));
                } else {
                    message = PreProdLogMessages.getParameterString("CODE_KEY_FORMAT_NO_MATCH", new Object[]{keyFormatName});
                    PreProdHolder.addLogEntry(new PreProdLogEntry("ERROR", "CODE_KEY_FORMAT_NO_MATCH", message));
                }
            }
            if (keyFormatName == null) {
                message = "key format name unknown, no rule match";
                LOG.warn((Object)message);
                throw new AnalyzeException(message, 1);
            }
        }
        Keyformat keyFormat = null;
        try {
            keyFormat = this.getKeyFormat(keyFormatName);
        }
        catch (AnalyzeException e) {
            if (PreProdHolder.getIsPreProd()) {
                String message = PreProdLogMessages.getParameterString("CODE_EXCEPTION", new Object[]{e.getLocalizedMessage()});
                PreProdHolder.addLogEntry(new PreProdLogEntry("ERROR", "CODE_EXCEPTION", message));
            }
            throw e;
        }
        return keyFormat;
    }

    private String getKeyFormatName(String hexData, List<TypeKeyFormatConfig> configs, boolean checkLength) {
        this.keyIsTruncated = false;
        String keyFormatName = null;
        String reason = null;
        for (TypeKeyFormatConfig config : configs) {
            String keyVar = config.getRaMagicBytes();
            Pattern p = Pattern.compile(keyVar);
            Matcher m = p.matcher(hexData);
            if (!m.matches()) continue;
            keyFormatName = config.getKeyFormatFile();
            LOG.info((Object)hexData);
            LOG.info((Object)("identified keyFormatName: " + keyFormatName));
            int requiredLength = config.getFileLength() * 2;
            int actualLength = hexData.length();
            if (checkLength) {
                if (requiredLength == actualLength) {
                    this.keyIsTruncated = false;
                    break;
                }
                keyFormatName = null;
                if (actualLength < requiredLength) {
                    this.keyIsTruncated = true;
                }
                reason = "data length of passed parameter (" + actualLength + ") does not suite to the key format one (" + requiredLength + ")";
                continue;
            }
            if (actualLength >= requiredLength) continue;
            this.keyIsTruncated = true;
        }
        if (this.keyIsTruncated && reason != null) {
            LOG.info(reason);
        }
        return keyFormatName;
    }

    private synchronized KeyFormatsConfig getKeyFormatConfig() {
        KeyFormatsConfig keyConfig = null;
        if (keyConfigurationCache.get(KEY_CONFIGURATION) == null) {
            LOG.info((Object)"init the key configuration cache");
            XMLReader dao = new XMLReader();
            keyConfig = dao.getKeyFormatsConfig();
            keyConfigurationCache.put(KEY_CONFIGURATION, keyConfig);
        } else {
            keyConfig = (KeyFormatsConfig)keyConfigurationCache.get(KEY_CONFIGURATION);
        }
        return keyConfig;
    }

    @Override
    public KeyDataTo createKeyData(byte[] data) throws AnalyzeException {
        LOG.debug((Object)"create the keyDataTo");
        KeyDataToImpl keyData = null;
        this.keyIsTruncated = false;
        Keyformat keyFormat = this.retrieveKeyFormat(Hex.encodeHex((byte[])data));
        if (keyFormat != null) {
            ProcessorBuilder builder = new ProcessorBuilder(keyFormat);
            keyData = builder.build(data);
            keyData.setKeyTruncated(this.keyIsTruncated);
        }
        return keyData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetInternalCache() {
        Cache cache = keyConfigurationCache;
        synchronized (cache) {
            keyConfigurationCache.reset();
        }
    }

    private Keyformat getKeyFormat(String keyFormatName) throws AnalyzeException {
        XMLReader dao = new XMLReader();
        Keyformat key = dao.getKeyFormat(keyFormatName);
        return key;
    }
}

