/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.ka.analyze;

import com.bmw.gki.ka.analyze.ComponentProcessor;
import com.bmw.gki.ka.analyze.CompositeProcessor;
import com.bmw.gki.ka.analyze.ProcessorWriteCache;
import com.bmw.gki.ka.jaxp.keyformat.BasicFieldType;
import com.bmw.gki.ka.keydata.FieldComponentTo;
import com.bmw.gki.ka.keydataimpl.FieldToImpl;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseFieldProcessor
extends ComponentProcessor {
    private BasicFieldType basicField;
    private Map<String, String> displayFieldMap;

    public BaseFieldProcessor(BasicFieldType newField) {
        this.basicField = newField;
        if (this.basicField.getDisplayValueList() != null) {
            this.displayFieldMap = new HashMap<String, String>();
            for (BasicFieldType.DisplayValueList.DisplayValue value : this.basicField.getDisplayValueList().getDisplayValue()) {
                this.displayFieldMap.put(value.getCodeValue(), value.getValue());
            }
        }
    }

    public FieldComponentTo getTo() {
        FieldToImpl field = new FieldToImpl();
        field.setId(this.basicField.getId());
        int byteLength = this.basicField.getByteLength();
        int fileOffset = this.basicField.getFileOffset();
        byte[] bytes = this.getParent().getBytes(fileOffset, byteLength);
        int fieldAddress = this.getParent().getFieldAddress(fileOffset);
        field.setFieldAddress(fieldAddress);
        String uniqueFiledId = this.getUniqueId();
        field.setFieldUniqueId(uniqueFiledId);
        field.setFieldLength(byteLength);
        field.setEditableFlag(this.isEditable());
        Object encodedValue = this.getEncodedValue(bytes);
        if (this.isFieldValueValid(encodedValue)) {
            field.setIsValid(true);
            this.fillValueIntoComponent(field, encodedValue, byteLength, bytes);
        } else {
            field.setIsValid(false);
        }
        ProcessorWriteCache.getInstance().setBaseFieldProcessor(this.getUniqueId(), this);
        return field;
    }

    public String getUniqueId() {
        String uniqueFiledId = "/" + this.basicField.getId();
        for (CompositeProcessor currentParent = this.getParent(); currentParent != null; currentParent = currentParent.getParent()) {
            String currentParentString = "/" + currentParent.getCurrentRecordId() + "_" + currentParent.getCurrentRecordNumber() + "_";
            uniqueFiledId = currentParentString + uniqueFiledId;
        }
        return uniqueFiledId;
    }

    protected void fillValueIntoComponent(FieldToImpl field, Object value, long length, byte[] byteValue) {
        field.setValue(value);
        field.setType(this.determineFieldValueType());
        field.setLength(length);
        field.setByteValue(byteValue);
    }

    protected abstract int determineFieldValueType();

    protected abstract Object getEncodedValue(byte[] var1);

    protected boolean isFieldValueValid(Object value) {
        return value != null;
    }

    protected abstract byte[] modifyBytes(String var1, byte[] var2);

    public String toString() {
        return this.basicField.getId() + " (" + this.basicField.getFileOffset() + ")";
    }

    protected abstract boolean isEditable();
}

