/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.ka.analyze;

import com.bmw.gki.ka.analyze.CompositeProcessor;
import com.bmw.gki.ka.analyze.ProcessorHelper;
import com.bmw.gki.ka.jep.Floor;
import com.bmw.gki.ka.jep.Round;
import com.bmw.gki.ka.keydata.FieldComponentTo;
import com.bmw.gki.ka.keydata.FieldTo;
import com.bmw.gki.logging.GKILogManager;
import org.apache.commons.logging.Log;
import org.nfunk.jep.JEP;
import org.nfunk.jep.function.PostfixMathCommandI;

public abstract class ComponentProcessor {
    private static final Log LOG = GKILogManager.getInstance().getLogger(ComponentProcessor.class);
    private CompositeProcessor parentProcessor = null;

    public void setParent(CompositeProcessor comp) {
        this.parentProcessor = comp;
    }

    public CompositeProcessor getParent() {
        return this.parentProcessor;
    }

    public void addProcessor(ComponentProcessor comp) {
    }

    public abstract FieldComponentTo getTo();

    protected Double calculateValue(String expression) {
        String[] vars = ProcessorHelper.extractVariables(expression);
        JEP myParser = this.createJEP();
        if (vars.length > 0) {
            for (int i = 0; i < vars.length; ++i) {
                FieldComponentTo comp = this.getParent().getTo(vars[i]);
                if (comp == null || !(comp instanceof FieldTo)) {
                    LOG.warn((Object)("component with id " + vars[i] + " not found "));
                    return null;
                }
                FieldTo field = (FieldTo)comp;
                LOG.info((Object)("current fieldTo id :" + field.getId() + " value: " + field.getValue()));
                Double dbValue = new Double(field.getValue().toString());
                myParser.addVariable(vars[i], (Object)dbValue);
            }
        }
        myParser.parseExpression(expression);
        Double result = new Double(myParser.getValue());
        return result;
    }

    protected JEP createJEP() {
        JEP myParser = new JEP();
        myParser.addFunction("round", (PostfixMathCommandI)new Round());
        myParser.addFunction("floor", (PostfixMathCommandI)new Floor());
        myParser.addStandardFunctions();
        myParser.addStandardConstants();
        return myParser;
    }
}

