/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.ka.analyze;

import com.bmw.gki.ka.analyze.ComponentProcessor;
import com.bmw.gki.ka.analyze.FileOffsetOutOfBounds;
import com.bmw.gki.ka.keydata.FieldComponentTo;
import com.bmw.gki.ka.keydata.FieldRecordTo;
import com.bmw.gki.ka.keydataimpl.FieldRecordToImpl;
import com.bmw.gki.ka.util.PreProdHolder;
import com.bmw.gki.ka.util.PreProdLogEntry;
import com.bmw.gki.logging.GKILogManager;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositeProcessor
extends ComponentProcessor {
    private static final Log LOG = GKILogManager.getInstance().getLogger(CompositeProcessor.class);
    private List<ComponentProcessor> composites = new ArrayList<ComponentProcessor>();
    private FieldRecordTo currentRecordTo;
    private int currentRecordNumber;

    protected abstract int getFileOffset();

    protected abstract int getRecordByteLength();

    @Override
    public void addProcessor(ComponentProcessor comp) {
        this.composites.add(comp);
        comp.setParent(this);
    }

    public List<ComponentProcessor> getProcessors() {
        ArrayList<ComponentProcessor> processorList = new ArrayList<ComponentProcessor>();
        processorList.addAll(this.composites);
        return processorList;
    }

    @Override
    public FieldComponentTo getTo() {
        this.currentRecordTo = new FieldRecordToImpl();
        this.currentRecordTo.setId(this.getCurrentRecordId());
        this.processChilds();
        return this.currentRecordTo;
    }

    protected abstract String getCurrentRecordId();

    protected void processChilds() {
        for (ComponentProcessor childPO : this.composites) {
            try {
                FieldComponentTo childTO = childPO.getTo();
                this.currentRecordTo.addFieldComponent(childTO);
            }
            catch (FileOffsetOutOfBounds foe) {
                String message = "field out of bounds:" + childPO.toString() + " in record " + this.getCurrentRecordNumber();
                LOG.info((Object)message);
                if (!PreProdHolder.getIsPreProd()) continue;
                PreProdHolder.addLogEntry(new PreProdLogEntry("ERROR", "CODE_EXCEPTION", message));
            }
        }
    }

    public FieldComponentTo getTo(String name) {
        return this.currentRecordTo.getFieldComponent(name);
    }

    protected byte[] getBytes(int childOffset, int count) {
        int offsetInParent = this.getFieldAddress(childOffset);
        return this.getParent().getBytes(offsetInParent, count);
    }

    protected int getFieldAddress(int childOffset) {
        return this.getFileOffset() + this.currentRecordNumber * this.getRecordByteLength() + childOffset;
    }

    protected int getCurrentRecordNumber() {
        return this.currentRecordNumber;
    }

    protected FieldRecordTo getCurrentRecordTo() {
        return this.currentRecordTo;
    }

    protected void setCurrentRecordNumber(int currentRecordNumber) {
        this.currentRecordNumber = currentRecordNumber;
    }

    protected void increaseCurrentRecordNumber() {
        ++this.currentRecordNumber;
    }

    protected void setCurrentRecordTo(FieldRecordTo currentRecordTo) {
        this.currentRecordTo = currentRecordTo;
        currentRecordTo.setId(this.getCurrentRecordId());
    }
}

