/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.ka.analyze;

import com.bmw.gki.ka.analyze.FieldListProcessor;
import com.bmw.gki.ka.jaxp.keyformat.DynamicFieldListType;
import com.bmw.gki.ka.jaxp.keyformat.FieldListBaseType;
import com.bmw.gki.ka.keydata.FieldComponentTo;
import com.bmw.gki.logging.GKILogManager;
import org.apache.commons.logging.Log;

public class DynFieldListProcessor
extends FieldListProcessor {
    static final Log LOG = GKILogManager.getInstance().getLogger(DynFieldListProcessor.class);
    private DynamicFieldListType dynamicFieldList;
    private int recordCount = 0;
    private int fileOffset = 0;

    public DynFieldListProcessor(FieldListBaseType newFieldList) {
        super(newFieldList);
        this.dynamicFieldList = (DynamicFieldListType)newFieldList;
    }

    public FieldComponentTo getTo() {
        String fileOffsetExpression = this.dynamicFieldList.getFileOffset();
        Double value = this.calculateValue(fileOffsetExpression);
        this.fileOffset = this.evaluate(value);
        String recordCountExpression = this.dynamicFieldList.getRecordCount();
        value = this.calculateValue(recordCountExpression);
        this.recordCount = this.evaluate(value);
        return super.getTo();
    }

    protected int getFileOffset() {
        return this.fileOffset;
    }

    protected int getRecordByteLength() {
        return this.dynamicFieldList.getRecordByteLength();
    }

    protected int getFieldListRecordCount() {
        return this.recordCount;
    }

    private int evaluate(Double value) {
        int retVal = 0;
        if (value != null) {
            retVal = value.intValue();
        }
        return retVal;
    }
}

