/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.ka.analyze;

import com.bmw.gki.ka.AnalyzeException;
import com.bmw.gki.ka.analyze.BCDFieldProcessor;
import com.bmw.gki.ka.analyze.BaseFieldProcessor;
import com.bmw.gki.ka.analyze.BinFieldProcessor;
import com.bmw.gki.ka.analyze.ComponentProcessor;
import com.bmw.gki.ka.analyze.CompositeProcessor;
import com.bmw.gki.ka.analyze.DecFieldProcessor;
import com.bmw.gki.ka.analyze.DynFieldListProcessor;
import com.bmw.gki.ka.analyze.FieldListProcessor;
import com.bmw.gki.ka.analyze.HexFieldProcessor;
import com.bmw.gki.ka.analyze.KeyDataProcessor;
import com.bmw.gki.ka.analyze.ProcessorWriteCache;
import com.bmw.gki.ka.analyze.StringFieldProcessor;
import com.bmw.gki.ka.jaxp.keyformat.BcdFieldType;
import com.bmw.gki.ka.jaxp.keyformat.BinFieldType;
import com.bmw.gki.ka.jaxp.keyformat.DecFieldType;
import com.bmw.gki.ka.jaxp.keyformat.DynamicFieldListType;
import com.bmw.gki.ka.jaxp.keyformat.FieldListType;
import com.bmw.gki.ka.jaxp.keyformat.HexFieldType;
import com.bmw.gki.ka.jaxp.keyformat.Keyformat;
import com.bmw.gki.ka.jaxp.keyformat.StrFieldType;
import com.bmw.gki.ka.keydata.FieldComponentTo;
import com.bmw.gki.ka.keydata.FieldCompositeTo;
import com.bmw.gki.ka.keydata.FieldRecordTo;
import com.bmw.gki.ka.keydata.FieldTo;
import com.bmw.gki.ka.keydataimpl.FieldToImpl;
import com.bmw.gki.ka.keydataimpl.KeyDataToImpl;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessorBuilder {
    private Keyformat keyFormat;

    public ProcessorBuilder(Keyformat newKeyformat) {
        this.keyFormat = newKeyformat;
    }

    public KeyDataToImpl build(byte[] newData) throws AnalyzeException {
        List<Object> elements = this.keyFormat.getFieldListOrDecFieldOrBinField();
        ProcessorWriteCache.getInstance().clear();
        KeyDataToImpl key = new KeyDataToImpl();
        KeyDataProcessor node = new KeyDataProcessor(newData);
        this.buildProcessorTreeList(node, elements);
        key.setFieldRecord((FieldRecordTo)node.getTo());
        return key;
    }

    public byte[] write(String id, String value, byte[] keyData) throws AnalyzeException {
        byte[] modifiedData = null;
        List<Object> elements = this.keyFormat.getFieldListOrDecFieldOrBinField();
        ProcessorWriteCache.getInstance().clear();
        KeyDataProcessor keyDataProcessor = new KeyDataProcessor(keyData);
        this.buildProcessorTreeList(keyDataProcessor, elements);
        KeyDataToImpl key = new KeyDataToImpl();
        key.setFieldRecord((FieldRecordTo)keyDataProcessor.getTo());
        FieldRecordTo fRecord = key.getFieldRecord();
        FieldComponentTo fieldCompTo = this.getFieldComponentToById(id, (FieldCompositeTo)fRecord);
        if (fieldCompTo != null && fieldCompTo instanceof FieldTo) {
            FieldTo fieldTo = (FieldTo)fieldCompTo;
            BaseFieldProcessor modBaseFieldProcessor = ProcessorWriteCache.getInstance().getBaseFieldProcessor(id);
            byte[] modifiedBytes = modBaseFieldProcessor.modifyBytes(value, fieldTo.getByteValue());
            keyDataProcessor.setBytes(fieldTo.getFieldAddress(), modifiedBytes);
        }
        modifiedData = keyDataProcessor.getBytes(0, keyData.length);
        ProcessorWriteCache.getInstance().clear();
        return modifiedData;
    }

    private FieldComponentTo getFieldComponentToById(String id, FieldCompositeTo fRecord) {
        FieldComponentTo fieldTo = null;
        Iterator fieldComponentsIter = fRecord.getFieldComponents().iterator();
        while (fieldComponentsIter.hasNext() && fieldTo == null) {
            FieldComponentTo fieldComponent = (FieldComponentTo)fieldComponentsIter.next();
            if (fieldComponent instanceof FieldToImpl) {
                if (!id.equals(((FieldToImpl)fieldComponent).getFieldUniqueId())) continue;
                fieldTo = fieldComponent;
                continue;
            }
            if (!(fieldComponent instanceof FieldCompositeTo)) continue;
            fieldTo = this.getFieldComponentToById(id, (FieldCompositeTo)fieldComponent);
        }
        return fieldTo;
    }

    private void buildProcessorTreeList(CompositeProcessor node, List<?> elements) throws AnalyzeException {
        for (Object element : elements) {
            this.buildProcessorTree(node, element);
        }
    }

    private void buildProcessorTree(ComponentProcessor node, Object o) throws AnalyzeException {
        ComponentProcessor cp = null;
        if (o instanceof DecFieldType) {
            cp = new DecFieldProcessor((DecFieldType)o);
        } else if (o instanceof StrFieldType) {
            cp = new StringFieldProcessor((StrFieldType)o);
        } else if (o instanceof HexFieldType) {
            cp = new HexFieldProcessor((HexFieldType)o);
        } else if (o instanceof BinFieldType) {
            cp = new BinFieldProcessor((BinFieldType)o);
        } else if (o instanceof BcdFieldType) {
            cp = new BCDFieldProcessor((BcdFieldType)o);
        } else if (o instanceof DynamicFieldListType) {
            DynamicFieldListType flType = (DynamicFieldListType)o;
            cp = new DynFieldListProcessor(flType);
            this.buildProcessorTreeList((CompositeProcessor)cp, flType.getDecFieldOrBinFieldOrStrField());
        } else if (o instanceof FieldListType) {
            FieldListType flType = (FieldListType)o;
            cp = new FieldListProcessor(flType);
            this.buildProcessorTreeList((CompositeProcessor)cp, flType.getDecFieldOrBinFieldOrStrField());
        } else {
            throw new AnalyzeException("unknown key component type " + o.getClass().getName(), 3);
        }
        node.addProcessor(cp);
    }
}

