/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.ka.dao;

import com.bmw.gki.ka.AnalyzeException;
import com.bmw.gki.ka.KeyAnalyzerFactory;
import com.bmw.gki.ka.TechnicalException;
import com.bmw.gki.ka.dao.DaoInterface;
import com.bmw.gki.ka.dao.ResourceResolver;
import com.bmw.gki.ka.jaxp.keyformat.Keyformat;
import com.bmw.gki.ka.jaxp.keyformatconfig.KeyFormatsConfig;
import com.bmw.gki.ka.util.Cache;
import com.bmw.gki.logging.GKILogManager;
import java.io.InputStream;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Date;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.logging.Log;
import org.xml.sax.SAXException;

public class XMLReader
implements DaoInterface {
    private static final Log LOG = GKILogManager.getInstance().getLogger(KeyAnalyzerFactory.class);
    private static final String KEY_FORMATS = "KEY_FORMATS";
    private KeyFormatsConfig keyFormatsConfig = null;
    private Cache keyFormatsCache = null;
    private static final String KEY_FILE_KEYFORMATS_CONFIG = "keyformats_config_v10.xml";
    private static final String KEY_FILE_KEYFORMATS_CONFIG_XSD = "key_formats_config.xsd";

    public synchronized KeyFormatsConfig getKeyFormatsConfig() {
        if (this.keyFormatsConfig == null) {
            String xmlFile = KEY_FILE_KEYFORMATS_CONFIG;
            try {
                CodeSource codeSource;
                ClassLoader classLoader = this.getClass().getClassLoader();
                JAXBContext context = JAXBContext.newInstance((String)KeyFormatsConfig.class.getPackage().getName(), (ClassLoader)classLoader);
                Unmarshaller unmarshaller = context.createUnmarshaller();
                SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                ProtectionDomain protectionDomain = this.getClass().getProtectionDomain();
                if (protectionDomain != null && (codeSource = protectionDomain.getCodeSource()) != null) {
                    sf.setResourceResolver(new ResourceResolver());
                    sf.newSchema(new StreamSource(classLoader.getResourceAsStream(KEY_FILE_KEYFORMATS_CONFIG_XSD)));
                }
                LOG.info((Object)("keyFormatConfig: " + xmlFile));
                InputStream stream = classLoader.getResourceAsStream(xmlFile);
                LOG.info((Object)("Path: " + classLoader.getResource(xmlFile).getPath()));
                this.keyFormatsConfig = (KeyFormatsConfig)unmarshaller.unmarshal(stream);
            }
            catch (JAXBException e) {
                LOG.fatal((Object)"cannot unsmarshall key formats config", (Throwable)e);
                throw new TechnicalException("cannot unmarshall key formats config ", (Throwable)e);
            }
            catch (SAXException e) {
                LOG.fatal((Object)"cannot validate key formats config", (Throwable)e);
                throw new TechnicalException("cannot validate key formats config ", (Throwable)e);
            }
        }
        return this.keyFormatsConfig;
    }

    public synchronized Keyformat getKeyFormat(String xmlFile) throws AnalyzeException {
        Keyformat keyFormat;
        long startTime = new Date().getTime();
        LOG.info((Object)("start getKeyFormat" + startTime + xmlFile));
        if (this.keyFormatsCache == null) {
            this.keyFormatsCache = new Cache(KEY_FORMATS);
        }
        if ((keyFormat = (Keyformat)this.keyFormatsCache.get(xmlFile)) == null) {
            try {
                ClassLoader classLoader = this.getClass().getClassLoader();
                JAXBContext context = JAXBContext.newInstance((String)Keyformat.class.getPackage().getName(), (ClassLoader)classLoader);
                InputStream stream = classLoader.getResourceAsStream(xmlFile);
                if (stream == null) {
                    String message = "xml file " + xmlFile + " not found";
                    throw new AnalyzeException(message, 0);
                }
                keyFormat = (Keyformat)context.createUnmarshaller().unmarshal(stream);
                this.keyFormatsCache.put(xmlFile, keyFormat);
            }
            catch (JAXBException e) {
                LOG.fatal((Object)("cannot unmarshall key formats from file:" + xmlFile), (Throwable)e);
                throw new TechnicalException("cannot unmarshall key formats ", (Throwable)e);
            }
        }
        long endTime = new Date().getTime();
        long duration = endTime - startTime;
        LOG.info((Object)("end getKeyFormat" + xmlFile));
        if (duration != 0L) {
            LOG.info((Object)("duration time : " + duration));
        }
        return keyFormat;
    }
}

