/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.ka.util;

public class ByteArrayWriter {
    public static byte[] getByteArrayFromInt(int value, byte[] originBytes, String bitmaskAsString, boolean isReverse) {
        if (originBytes.length > 4) {
            return null;
        }
        if (bitmaskAsString != null) {
            int bitLength = bitmaskAsString.length();
            double bitLengthAsByte = bitmaskAsString.length() / 8;
            if (bitLength > 32 || bitLengthAsByte != (double)originBytes.length) {
                return null;
            }
            long originByteValue = ByteArrayWriter.toInt(originBytes);
            ByteArrayWriter.print("originByteValue= " + Long.toBinaryString(originByteValue));
            long newValue = value;
            ByteArrayWriter.print("newValue= " + Long.toBinaryString(newValue));
            long bitmask = Long.parseLong(bitmaskAsString, 2);
            ByteArrayWriter.print("bitmask= " + Long.toBinaryString(bitmask));
            long peparedOldOriginByteValue = originByteValue | bitmask;
            ByteArrayWriter.print("1. peparedOldOriginByteValue= " + Long.toBinaryString(peparedOldOriginByteValue));
            long shiftedNewValue = ByteArrayWriter.shiftNewValue(bitmaskAsString, newValue);
            ByteArrayWriter.print("3. shiftedNewValue= " + Long.toBinaryString(shiftedNewValue));
            long bitmaskComplement = bitmask ^ 0xFFFFFFFFFFFFFFFFL;
            ByteArrayWriter.print("4. bitmaskComplement= " + Long.toBinaryString(bitmaskComplement));
            long newValueWithBitsForOldValues = bitmaskComplement | shiftedNewValue;
            ByteArrayWriter.print("5. newValueWithBitsForOldValues= " + Long.toBinaryString(newValueWithBitsForOldValues));
            long resultValue = newValueWithBitsForOldValues & peparedOldOriginByteValue;
            ByteArrayWriter.print("6. resultValue= " + Long.toBinaryString(newValue));
            value = new Long(resultValue).intValue();
        }
        byte[] bytes = ByteArrayWriter.toByteArray(value, originBytes.length);
        if (isReverse) {
            ByteArrayWriter.reverse(bytes);
        }
        return bytes;
    }

    private static long shiftNewValue(String bitmaskAsString, long newNum) {
        int firstBitFlagOfMask = bitmaskAsString.indexOf("1");
        int lastBitFlagOfMask = bitmaskAsString.lastIndexOf("1");
        int numberOfBitFlags = lastBitFlagOfMask - firstBitFlagOfMask;
        ByteArrayWriter.print("L\u00e4nge der BitMaske =" + bitmaskAsString.length());
        ByteArrayWriter.print("Bit Flags in BitMaske: Erster:" + firstBitFlagOfMask + " Letzter:" + lastBitFlagOfMask + " Anzahl:" + numberOfBitFlags);
        long shiftedNewValue = 0L;
        if (lastBitFlagOfMask + 1 == bitmaskAsString.length()) {
            shiftedNewValue = newNum;
        } else {
            int shiftFactor = bitmaskAsString.length() - (lastBitFlagOfMask + 1);
            shiftedNewValue = newNum << shiftFactor;
        }
        return shiftedNewValue;
    }

    public static void print(String toPrint) {
    }

    private static byte[] toByteArray(int integer, int length) {
        byte[] byteArray = new byte[length];
        for (int j = 0; j < byteArray.length; ++j) {
            int factor = byteArray.length - j;
            byteArray[j] = factor > 1 ? (byte)(integer >> (factor - 1) * 8) : (byte)integer;
        }
        return byteArray;
    }

    private static int toInt(byte[] bytes) {
        int result = 0;
        for (int i = 0; i < bytes.length; ++i) {
            if (i > 0) {
                result <<= 8;
            }
            result += bytes[i] & 0xFF;
        }
        return result;
    }

    private static void reverse(byte[] bytes) {
        byte buffer = 0;
        int upperBoundery = bytes.length - 1;
        int i = 0;
        while ((double)i < Math.floor(bytes.length / 2)) {
            buffer = bytes[i];
            bytes[i] = bytes[upperBoundery - i];
            bytes[upperBoundery - i] = buffer;
            ++i;
        }
    }
}

