/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.ka.util;

import com.bmw.gki.ka.TechnicalException;
import com.bmw.gki.ka.analyze.AnalyzeComponentImpl;
import com.bmw.gki.logging.GKILogManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;

public final class ConfigurationManager {
    public static final String KEY_FILE_KEYFORMATS_CONFIG = "file.keyformats_config_new";
    private static final Log LOG = GKILogManager.getInstance().getLogger(AnalyzeComponentImpl.class);
    private Properties configuration;
    private static ConfigurationManager config = new ConfigurationManager();

    private ConfigurationManager() {
    }

    public static ConfigurationManager getInstance() {
        return config;
    }

    public synchronized void load(String fileName) {
        this.configuration = new Properties();
        try {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(fileName);
            this.configuration.load(stream);
        }
        catch (IOException e) {
            throw new TechnicalException("not able to load property file ", (Throwable)e);
        }
    }

    public String getValue(String key) {
        String value = this.configuration.getProperty(key);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("retrieve key " + key + " with value" + value));
        }
        return value;
    }
}

