/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.external.cache;

import com.bmw.gki.ka.util.PreProdHolder;
import com.bmw.gki.ka.util.PreProdLogEntry;
import com.bmw.gki.ka.util.PreProdLogMessages;
import com.bmw.gki.klib.api.exception.KSDPropertyFormatException;
import com.bmw.gki.klib.external.cache.KSDReaderIF;
import com.bmw.gki.logging.GKILogManager;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;

public class CCMessageReader
implements KSDReaderIF {
    private static Log log = GKILogManager.getInstance().getLogger(CCMessageReader.class);
    public static final String DEFAULT = "ccmessage.properties";
    private static Properties ccMessages = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readInTable(String path) throws KSDPropertyFormatException {
        block15: {
            InputStream in = null;
            try {
                if (path != null && path.length() > 0) {
                    in = new FileInputStream(path);
                    ccMessages.load(in);
                    break block15;
                }
                if (PreProdHolder.getIsPreProd()) {
                    String message = PreProdLogMessages.getParameterString("CODE_FILE_NOT_FOUND", new Object[]{"" + path});
                    PreProdHolder.addLogEntry(new PreProdLogEntry("INFO", "CODE_FILE_NOT_FOUND", message));
                    break block15;
                }
                String message = "CC Message Reader path not set: " + path;
                KSDPropertyFormatException pex = new KSDPropertyFormatException(message);
                log.info((Object)message);
                throw pex;
            }
            catch (Exception e) {
                if (PreProdHolder.getIsPreProd()) {
                    String message = PreProdLogMessages.getParameterString("CODE_FILE_NOT_FOUND", new Object[]{"" + path});
                    PreProdHolder.addLogEntry(new PreProdLogEntry("INFO", "CODE_FILE_NOT_FOUND", message));
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static String find(String engineeringSeries) {
        log.trace((Object)("find ccMessage for engineering series : " + engineeringSeries));
        if (ccMessages != null) {
            String result = ccMessages.getProperty(CCMessageReader.removeWhitespace(engineeringSeries));
            log.trace((Object)("found ccMessage: " + result));
            return result;
        }
        return null;
    }

    private static String removeWhitespace(String string) {
        if (string != null) {
            string = string.trim();
        }
        return string;
    }

    public static void reset() {
        ccMessages = new Properties();
    }
}

