/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.kr.gki.api;

import ca.beq.util.win32.registry.RegistryKey;
import ca.beq.util.win32.registry.RegistryValue;
import ca.beq.util.win32.registry.RootKey;
import com.bmw.gki.klib.api.AdminInterface;
import com.bmw.gki.klib.api.KeyInterpreter_V03_00_00;
import com.bmw.gki.klib.api.exception.AnalyserException;
import com.bmw.gki.klib.api.exception.JarLoadException;
import com.bmw.gki.klib.api.exception.KSDAccessException;
import com.bmw.gki.klib.api.exception.KSDVersionException;
import com.bmw.gki.klib.api.exception.SystemException;
import com.bmw.gki.klib.api_V03_00_00.KeyDataAnalysedType;
import com.bmw.gki.klib.api_V03_00_00.KeyDataBinType;
import com.bmw.gki.klib.api_V03_00_00.OrderBaseType;
import com.bmw.gki.klib.api_V03_00_00.TypeError;
import com.bmw.gki.klib.api_V03_00_00.impl.KeyDataBinTypeImpl;
import com.bmw.gki.klib.common.Einstellungen;
import com.bmw.gki.klib.external.cache.KSDCache;
import com.bmw.kr.gki.exception.KeyReaderException;
import com.bmw.kr.gki.exception.KrGkiException;
import com.bmw.kr.gki.exception.NoKeyException;
import com.bmw.kr.gki.exception.TimeoutException;
import com.bmw.kr.gki.keyreader.KeyReaderAccess;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KrGkiKeyReader {
    public static final String PROP_SKIP_KEYREADER_BIN_FILE_PATH = "skipKeyReaderBinFilePath";
    public static final String PROP_KEYREADER_PIPE_DLL_PATH = "keyReaderPipeDllPath";
    public static final String PROP_MAX_TIMEOUT = "maxTimeout";
    public static final String PROP_KSD_DIR = "ksdDir";
    public static final String PROP_KAIMPL_DIR = "kaImplDir";
    public static final String PROP_LOCALE = "locale";
    public static final String PROP_IS_MILES = "isMiles";
    private static final String PROPERTIES_FILE = "/kr_gki.properties";
    private static int byteSize = 544;
    private static final String ORIGIN = "K";
    private static final boolean IS_MILES = false;
    private static final String KA_IMPL_DIR = "lib/ka_impl.jar";
    private static final Log log = LogFactory.getLog(KrGkiKeyReader.class);
    private byte[] keydata;
    private int bytesRead = 0;
    private Date readin = new Date();
    private Properties properties;
    private String keyReaderPipeDllPath;
    private Locale locale;
    private String kaImplDir;
    private String ksdDir;
    private int maxTimeout;
    private String skipKeyReaderBinFilePath;
    private Boolean skipKeyReader;

    public KrGkiKeyReader() {
        this(null);
    }

    public KrGkiKeyReader(Properties properties) {
        this.keydata = new byte[byteSize];
        this.readProperties();
        if (properties != null) {
            this.properties.putAll((Map<?, ?>)properties);
        }
        this.initializeGki();
    }

    private void initializeGki() {
        String ksdDir = this.getKsdDir();
        if (ksdDir != null && ksdDir.trim().length() > 0) {
            this.initializeGKIWithKSD(ksdDir);
        } else {
            String kaImplDir = this.getKaImplDir();
            this.initializeGKIWithoutKSD(kaImplDir);
        }
    }

    private void initializeGKIWithoutKSD(String kaImplDir) {
        log.debug((Object)("initialize gki without ksd " + kaImplDir));
        KSDCache.reset();
        try {
            AdminInterface.setKeyAnalyserLibPath((String)kaImplDir);
        }
        catch (FileNotFoundException e) {
            log.error((Object)"Error initializing GKI without KSD", (Throwable)e);
        }
        catch (JarLoadException e) {
            log.error((Object)"Error initializing GKI without KSD", (Throwable)e);
        }
    }

    private void initializeGKIWithKSD(String ksdDir) {
        log.debug((Object)("initialize gki with ksd " + ksdDir));
        KSDCache.reset();
        try {
            AdminInterface.setKSDPath((String)ksdDir, (boolean)true);
        }
        catch (KSDVersionException e) {
            log.error((Object)("Error initializing GKI with KSD, errorCode: " + e.getErrorCode()), (Throwable)e);
        }
        catch (KSDAccessException e) {
            log.error((Object)("Error initializing GKI with KSD, errorCode: " + e.getErrorCode()), (Throwable)e);
        }
        catch (JarLoadException e) {
            log.error((Object)("Error initializing GKI with KSD, errorCode: " + e.getErrorCode()), (Throwable)e);
        }
    }

    public boolean existKeyReader() {
        log.debug((Object)"+KrGkiKeyReader.existKeyReader");
        boolean existKeyReader = true;
        if (this.isSkipKeyReader()) {
            log.debug((Object)("skip key reader -> result: " + existKeyReader));
        } else {
            try {
                this.provideKeydataFromKeyreader(this.keydata, this.readin);
            }
            catch (NoKeyException e) {
                existKeyReader = true;
            }
            catch (Exception e) {
                existKeyReader = false;
            }
        }
        log.debug((Object)"-KrGkiKeyReader.existKeyReader");
        return existKeyReader;
    }

    public String retrieveVin() throws KrGkiException {
        log.debug((Object)"+KrGkiKeyReader.retrieveVin");
        String vin = null;
        byte[] tempKeyData = this.provideKeydataFromKeyreader(this.keydata, this.readin);
        String origin = this.getOrigin();
        Locale locale = this.getLocale();
        KeyDataBinType keydata = this.getKeyData(tempKeyData, this.readin, origin);
        try {
            KeyInterpreter_V03_00_00 keyInterpreter = new KeyInterpreter_V03_00_00();
            vin = keyInterpreter.retrieveVin(keydata, locale);
        }
        catch (AnalyserException e) {
            throw new KrGkiException("retrieveVin", e);
        }
        log.debug((Object)"-KrGkiKeyReader.retrieveVin");
        return vin;
    }

    public OrderBaseType interpretKey() throws KrGkiException {
        log.debug((Object)"+KrGkiKeyReader.interpretKey");
        OrderBaseType orderBase = null;
        byte[] tempKeyData = this.provideKeydataFromKeyreader(this.keydata, this.readin);
        String origin = this.getOrigin();
        Locale locale = this.getLocale();
        boolean isMiles = this.isMiles();
        ArrayList warnings = new ArrayList();
        KeyDataBinType keydata = this.getKeyData(tempKeyData, this.readin, origin);
        try {
            KeyInterpreter_V03_00_00 keyInterpreter = new KeyInterpreter_V03_00_00();
            orderBase = keyInterpreter.interpretKeyData(keydata, locale, isMiles, warnings);
            for (Object obj : warnings) {
                if (!(obj instanceof TypeError)) continue;
                TypeError element = (TypeError)obj;
                String errorDescription = element.getErrorDescriptionLocal();
                log.warn((Object)("warning: " + element.getErrorCode() + ": " + errorDescription));
            }
        }
        catch (AnalyserException e) {
            throw new KrGkiException("interpretKey", e);
        }
        catch (KSDAccessException e) {
            throw new KrGkiException("interpretKey", e);
        }
        catch (SystemException e) {
            throw new KrGkiException("interpretKey", e);
        }
        log.debug((Object)"-KrGkiKeyReader.interpretKey");
        return orderBase;
    }

    public KeyDataAnalysedType analyseKey() throws KrGkiException {
        log.debug((Object)"+KrGkiKeyReader.analyseKey");
        KeyDataAnalysedType keyDataAnalysed = null;
        byte[] tempKeyData = this.provideKeydataFromKeyreader(this.keydata, this.readin);
        String origin = this.getOrigin();
        Locale locale = this.getLocale();
        KeyDataBinType keydata = this.getKeyData(tempKeyData, this.readin, origin);
        try {
            KeyInterpreter_V03_00_00 keyInterpreter = new KeyInterpreter_V03_00_00();
            keyDataAnalysed = keyInterpreter.analyseKeyData(keydata, locale);
        }
        catch (AnalyserException e) {
            throw new KrGkiException("analyseKey", e);
        }
        catch (SystemException e) {
            throw new KrGkiException("analyseKey", e);
        }
        log.debug((Object)"-KrGkiKeyReader.analyseKey");
        return keyDataAnalysed;
    }

    private KeyDataBinType getKeyData(byte[] content, Date readin, String origin) {
        KeyDataBinTypeImpl keyData = new KeyDataBinTypeImpl();
        keyData.setContent(content);
        GregorianCalendar gregorianCalendar = null;
        XMLGregorianCalendar xmlDate = null;
        if (readin != null) {
            gregorianCalendar = new GregorianCalendar();
            try {
                xmlDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
            }
            catch (DatatypeConfigurationException e) {
                // empty catch block
            }
        }
        keyData.setReadInDate(xmlDate);
        return keyData;
    }

    private byte[] provideKeydataFromKeyreader(byte[] keydata, Date readin) throws KeyReaderException, TimeoutException {
        log.debug((Object)"+KrGkiKeyReader.provideKeydataFromKeyreader");
        String skipKeyReaderBinFilePath = this.getSkipKeyReaderBinFilePath();
        log.info((Object)("skipKeyReaderBinFilePath: " + skipKeyReaderBinFilePath));
        boolean skipKeyReader = this.isSkipKeyReader();
        log.info((Object)("skipKeyReader: " + skipKeyReader));
        String keyReaderPipeDllPath = null;
        if (!skipKeyReader) {
            keyReaderPipeDllPath = this.getKeyReaderPipeDllPath();
        }
        log.info((Object)("keyReaderPipeDllPath: " + keyReaderPipeDllPath));
        int maxTimeout = this.getMaxTimeout();
        log.info((Object)("maxTimeout: " + maxTimeout));
        KeyReaderAccess keyReader = new KeyReaderAccess();
        keyReader.retrieveKeydata(keydata, readin, maxTimeout, keyReaderPipeDllPath, skipKeyReader, skipKeyReaderBinFilePath);
        this.bytesRead = keyReader.getBytesRead();
        log.debug((Object)("bytesRead=" + this.bytesRead));
        byte[] tempKeyData = new byte[this.bytesRead];
        System.arraycopy(keydata, 0, tempKeyData, 0, this.bytesRead);
        log.debug((Object)"-KrGkiKeyReader.provideKeydataFromKeyreader");
        return tempKeyData;
    }

    private boolean isMiles() {
        boolean isMiles = false;
        if (this.properties != null) {
            isMiles = "true".equalsIgnoreCase(this.properties.getProperty(PROP_IS_MILES));
        }
        return isMiles;
    }

    private String getOrigin() {
        return ORIGIN;
    }

    private Locale getLocale() {
        if (this.locale == null) {
            ArrayList<Locale> supportedLocales;
            String param;
            if (this.properties != null && (param = this.properties.getProperty(PROP_LOCALE)) != null) {
                String language = null;
                String country = "";
                StringTokenizer st = new StringTokenizer(param, "_");
                if (st.hasMoreTokens()) {
                    language = st.nextToken().toLowerCase();
                }
                if (st.hasMoreTokens()) {
                    country = st.nextToken().toUpperCase();
                }
                this.locale = new Locale(language, country);
            }
            if (this.locale != null && !(supportedLocales = new ArrayList<Locale>(Arrays.asList(Einstellungen.getSupportedLocales()))).contains(this.locale)) {
                this.locale = null;
            }
            if (this.locale == null) {
                this.locale = Locale.UK;
            }
        }
        return this.locale;
    }

    private String getKeyReaderPipeDllPath() {
        if (this.keyReaderPipeDllPath == null) {
            if (this.properties != null) {
                this.keyReaderPipeDllPath = this.properties.getProperty(PROP_KEYREADER_PIPE_DLL_PATH);
            }
            if (this.keyReaderPipeDllPath == null || !this.checkKeyReaderPipeDllPath(this.keyReaderPipeDllPath)) {
                this.keyReaderPipeDllPath = this.getKeyReaderPipeDllPathFromRegistry();
                this.checkKeyReaderPipeDllPath(this.keyReaderPipeDllPath);
            }
        }
        return this.keyReaderPipeDllPath;
    }

    private String getKeyReaderPipeDllPathFromRegistry() {
        String dir;
        String regKey;
        String path = null;
        String regPath = this.getKeyReaderRegPath();
        RegistryKey registryKey = new RegistryKey(RootKey.HKEY_LOCAL_MACHINE, regPath);
        RegistryValue v = registryKey.getValue(regKey = this.getKeyReaderRegKey());
        if (v != null && (dir = v.getStringValue()) != null) {
            File file = new File(dir, "KeyreaderPipe.dll");
            path = file.getAbsolutePath();
        }
        return path;
    }

    private boolean checkKeyReaderPipeDllPath(String keyReaderPipeDllPath) {
        File file;
        if (keyReaderPipeDllPath != null && !(file = new File(keyReaderPipeDllPath)).exists()) {
            log.warn((Object)("key reader pipe dll path does not exist in the file system: " + file.getAbsolutePath()));
            return false;
        }
        return true;
    }

    private String getKaImplDir() {
        if (this.kaImplDir == null) {
            this.kaImplDir = KA_IMPL_DIR;
            if (this.properties != null) {
                this.kaImplDir = this.properties.getProperty(PROP_KAIMPL_DIR, this.kaImplDir);
            }
        }
        return this.kaImplDir;
    }

    private String getKsdDir() {
        if (this.ksdDir == null && this.properties != null) {
            this.ksdDir = this.properties.getProperty(PROP_KSD_DIR);
        }
        return this.ksdDir;
    }

    private int getMaxTimeout() {
        if (this.maxTimeout == 0) {
            String timeout;
            this.maxTimeout = 60;
            if (this.properties != null && (timeout = this.properties.getProperty(PROP_MAX_TIMEOUT, String.valueOf(this.maxTimeout))) != null) {
                try {
                    this.maxTimeout = Integer.parseInt(timeout);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return this.maxTimeout;
    }

    private boolean isSkipKeyReader() {
        if (this.skipKeyReader == null) {
            this.skipKeyReader = this.getSkipKeyReaderBinFilePath() != null;
        }
        return this.skipKeyReader;
    }

    private String getSkipKeyReaderBinFilePath() {
        if (this.skipKeyReaderBinFilePath == null && this.properties != null) {
            this.skipKeyReaderBinFilePath = this.properties.getProperty(PROP_SKIP_KEYREADER_BIN_FILE_PATH);
        }
        return this.skipKeyReaderBinFilePath;
    }

    private String getKeyReaderRegPath() {
        String path = "SOFTWARE\\BMWgroup\\KEYREADER";
        return path;
    }

    private String getKeyReaderRegKey() {
        String key = "Home";
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readProperties() {
        InputStream in = null;
        try {
            in = KrGkiKeyReader.class.getResourceAsStream(PROPERTIES_FILE);
            if (in == null) {
                log.warn((Object)"no properties file found");
            } else {
                this.properties = new Properties();
                this.properties.load(in);
                log.debug((Object)("properties: " + this.properties));
                URL url = KrGkiKeyReader.class.getResource(PROPERTIES_FILE);
                log.debug((Object)("properties read from url " + url));
            }
        }
        catch (Exception e) {
            log.error((Object)"Error reading properties /kr_gki.properties", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

