/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.kr.gki.exception;

import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Messages {
    private static Messages instance;
    private static final HashMap BUNDLES;
    private static final String BUNDLE_NAME = " com.bmw.kr.gki.exception.KrGkiExceptionMessages";
    private static final Locale DE;
    private static final Locale EN;
    private static Log log;

    private Messages() {
        ClassLoader loader = Messages.class.getClassLoader();
        ResourceBundle rbde = ResourceBundle.getBundle(BUNDLE_NAME, DE, loader);
        ResourceBundle rben = ResourceBundle.getBundle(BUNDLE_NAME, EN, loader);
        BUNDLES.put("krGki_de", rbde);
        BUNDLES.put("krGki_en", rben);
    }

    public static Messages getInstance() {
        if (instance == null) {
            instance = new Messages();
        }
        return instance;
    }

    public String getString(String key) {
        return instance.getStringLocalized(key, DE);
    }

    public String getStringLocalized(String key, Locale locale) {
        log.debug((Object)"+Messages.getStringLocalized");
        String s = "";
        ResourceBundle bundle = (ResourceBundle)(locale == DE ? BUNDLES.get("krGki_de") : BUNDLES.get("krGki_en"));
        if (bundle == null) {
            log.error((Object)("Bundle was not found for: " + key + "!!"));
            s = "ResourceBundle not found for key " + key;
        } else {
            s = bundle.getString(key);
            if (s == null) {
                s = "Message for key not found: " + key;
            }
        }
        log.debug((Object)"-Messages.getStringLocalized");
        return s;
    }

    static {
        BUNDLES = new HashMap();
        DE = Locale.GERMAN;
        EN = Locale.ENGLISH;
        log = LogFactory.getLog(Messages.class);
    }
}

