/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.kr.gki.keyreader;

import com.bmw.kr.gki.exception.DirectoryAccessException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReadKeyBin {
    private static Log log = LogFactory.getLog(ReadKeyBin.class);
    private int bytesRead;

    public void readData(byte[] b, String filename) throws DirectoryAccessException {
        log.debug((Object)("+ReadKeyBin.readData" + filename));
        File file = new File(filename);
        if (!file.exists()) {
            log.info((Object)(".readFile - file " + filename + " not exists"));
        }
        this.bytesRead = 0;
        InputStream in = null;
        ByteArrayOutputStream out = null;
        try {
            in = new BufferedInputStream(new FileInputStream(filename));
            out = new ByteArrayOutputStream();
            int by = -1;
            while ((by = in.read()) != -1) {
                out.write(by);
            }
            out.flush();
            this.bytesRead = out.size();
            log.debug((Object)("readData -> bytes read: " + this.bytesRead));
            System.arraycopy(out.toByteArray(), 0, b, 0, this.bytesRead);
            log.debug((Object)"-ReadKeyBin.readData");
        }
        catch (Exception e) {
            log.info((Object)"File input error", (Throwable)e);
            throw new DirectoryAccessException();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public int getBytesRead() {
        return this.bytesRead;
    }

    public void setBytesRead(int bytesRead) {
        this.bytesRead = bytesRead;
    }
}

