/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.kr.gki.regutil;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.prefs.Preferences;

public class RegUtil {
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int ERROR_SUCCESS = 0;
    public static final int ERROR_FILE_NOT_FOUND = 2;
    public static final int ERROR_ACCESS_DENIED = 5;
    public static final int NATIVE_HANDLE = 0;
    public static final int ERROR_CODE = 1;
    public static final int SUBKEYS_NUMBER = 0;
    public static final int VALUES_NUMBER = 2;
    public static final int MAX_KEY_LENGTH = 3;
    public static final int MAX_VALUE_NAME_LENGTH = 4;
    public static final int DISPOSITION = 2;
    public static final int REG_CREATED_NEW_KEY = 1;
    public static final int REG_OPENED_EXISTING_KEY = 2;
    public static final int NULL_NATIVE_HANDLE = 0;
    public static final int DELETE = 65536;
    public static final int KEY_QUERY_VALUE = 1;
    public static final int KEY_SET_VALUE = 2;
    public static final int KEY_CREATE_SUB_KEY = 4;
    public static final int KEY_ENUMERATE_SUB_KEYS = 8;
    public static final int KEY_READ = 131097;
    public static final int KEY_WRITE = 131078;
    public static final int KEY_ALL_ACCESS = 983103;
    private static final Preferences userRoot = Preferences.userRoot();
    private static final Preferences systemRoot = Preferences.systemRoot();
    private static Class userClass = null;
    private static Class systemClass = null;
    private static Method windowsRegOpenKey = null;
    private static Method windowsRegCloseKey = null;
    private static Method windowsRegCreateKeyEx = null;
    private static Method windowsRegDeleteKey = null;
    private static Method windowsRegFlushKey = null;
    private static Method windowsRegQueryValueEx = null;
    private static Method windowsRegSetValueEx = null;
    private static Method windowsRegDeleteValue = null;
    private static Method windowsRegQueryInfoKey = null;
    private static Method windowsRegEnumKeyEx = null;
    private static Method windowsRegEnumValue = null;

    public static int[] RegOpenKey(int hKey, byte[] subKey, int securityMask) {
        try {
            return (int[])windowsRegOpenKey.invoke((Object)systemRoot, new Integer(hKey), subKey, new Integer(securityMask));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return new int[0];
    }

    public static int[] RegOpenKey(int hKey, String subKey, int securityMask) {
        return RegUtil.RegOpenKey(hKey, RegUtil.stringToByteArray(subKey), securityMask);
    }

    public static int RegCloseKey(int hKey) {
        try {
            return (Integer)windowsRegCloseKey.invoke((Object)systemRoot, new Integer(hKey));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return 5;
    }

    public static int[] RegCreateKeyEx(int hKey, byte[] subKey) {
        try {
            return (int[])windowsRegCreateKeyEx.invoke((Object)systemRoot, new Integer(hKey), subKey);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return new int[0];
    }

    public static int[] RegCreateKeyEx(int hKey, String subKey) {
        return RegUtil.RegCreateKeyEx(hKey, RegUtil.stringToByteArray(subKey));
    }

    public static int RegDeleteKey(int hKey, byte[] subKey) {
        try {
            return (Integer)windowsRegDeleteKey.invoke((Object)systemRoot, new Integer(hKey), subKey);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return 5;
    }

    public static int RegDeleteKey(int hKey, String subKey) {
        return RegUtil.RegDeleteKey(hKey, RegUtil.stringToByteArray(subKey));
    }

    public static int RegFlushKey(int hKey) {
        try {
            return (Integer)windowsRegFlushKey.invoke((Object)systemRoot, new Integer(hKey));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return 5;
    }

    public static byte[] RegQueryValueEx(int hKey, byte[] valueName) {
        try {
            return (byte[])windowsRegQueryValueEx.invoke((Object)systemRoot, new Integer(hKey), valueName);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return new byte[0];
    }

    public static byte[] RegQueryValueEx(int hKey, String valueName) {
        return RegUtil.RegQueryValueEx(hKey, RegUtil.stringToByteArray(valueName));
    }

    public static int RegSetValueEx(int hKey, byte[] valueName, byte[] value) {
        try {
            return (Integer)windowsRegSetValueEx.invoke((Object)systemRoot, new Integer(hKey), valueName, value);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return 5;
    }

    public static int RegSetValueEx(int hKey, String valueName, String value) {
        return RegUtil.RegSetValueEx(hKey, RegUtil.stringToByteArray(valueName), RegUtil.stringToByteArray(value));
    }

    public static int RegDeleteValue(int hKey, byte[] valueName) {
        try {
            return (Integer)windowsRegDeleteValue.invoke((Object)systemRoot, new Integer(hKey), valueName);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return 5;
    }

    public static int RegDeleteValue(int hKey, String valueName) {
        return RegUtil.RegDeleteValue(hKey, RegUtil.stringToByteArray(valueName));
    }

    public static int[] RegQueryInfoKey(int hKey) {
        try {
            return (int[])windowsRegQueryInfoKey.invoke((Object)systemRoot, new Integer(hKey));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return new int[0];
    }

    public static byte[] RegEnumKeyEx(int hKey, int subKeyIndex, int maxKeyLength) {
        try {
            return (byte[])windowsRegEnumKeyEx.invoke((Object)systemRoot, new Integer(hKey), new Integer(subKeyIndex), new Integer(maxKeyLength));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return new byte[0];
    }

    public static byte[] RegEnumValue(int hKey, int valueIndex, int maxValueNameLength) {
        try {
            return (byte[])windowsRegEnumValue.invoke((Object)systemRoot, new Integer(hKey), new Integer(valueIndex), new Integer(maxValueNameLength));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return new byte[0];
    }

    public static byte[] stringToByteArray(String str) {
        byte[] result = new byte[str.length() + 1];
        for (int i = 0; i < str.length(); ++i) {
            result[i] = (byte)str.charAt(i);
        }
        result[str.length()] = 0;
        return result;
    }

    static {
        userClass = userRoot.getClass();
        systemClass = systemRoot.getClass();
        try {
            windowsRegOpenKey = userClass.getDeclaredMethod("WindowsRegOpenKey", Integer.TYPE, byte[].class, Integer.TYPE);
            windowsRegOpenKey.setAccessible(true);
            windowsRegCloseKey = userClass.getDeclaredMethod("WindowsRegCloseKey", Integer.TYPE);
            windowsRegCloseKey.setAccessible(true);
            windowsRegCreateKeyEx = userClass.getDeclaredMethod("WindowsRegCreateKeyEx", Integer.TYPE, byte[].class);
            windowsRegCreateKeyEx.setAccessible(true);
            windowsRegDeleteKey = userClass.getDeclaredMethod("WindowsRegDeleteKey", Integer.TYPE, byte[].class);
            windowsRegDeleteKey.setAccessible(true);
            windowsRegFlushKey = userClass.getDeclaredMethod("WindowsRegFlushKey", Integer.TYPE);
            windowsRegFlushKey.setAccessible(true);
            windowsRegQueryValueEx = userClass.getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, byte[].class);
            windowsRegQueryValueEx.setAccessible(true);
            windowsRegSetValueEx = userClass.getDeclaredMethod("WindowsRegSetValueEx", Integer.TYPE, byte[].class, byte[].class);
            windowsRegSetValueEx.setAccessible(true);
            windowsRegDeleteValue = userClass.getDeclaredMethod("WindowsRegDeleteValue", Integer.TYPE, byte[].class);
            windowsRegDeleteValue.setAccessible(true);
            windowsRegQueryInfoKey = userClass.getDeclaredMethod("WindowsRegQueryInfoKey", Integer.TYPE);
            windowsRegQueryInfoKey.setAccessible(true);
            windowsRegEnumKeyEx = userClass.getDeclaredMethod("WindowsRegEnumKeyEx", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            windowsRegEnumKeyEx.setAccessible(true);
            windowsRegEnumValue = userClass.getDeclaredMethod("WindowsRegEnumValue", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            windowsRegEnumValue.setAccessible(true);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }
}

