/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.client.p2p;

import com.sun.xml.internal.messaging.saaj.SOAPExceptionImpl;
import com.sun.xml.internal.messaging.saaj.util.Base64;
import com.sun.xml.internal.messaging.saaj.util.ByteInputStream;
import com.sun.xml.internal.messaging.saaj.util.ParseUtil;
import com.sun.xml.internal.messaging.saaj.util.SAAJUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

class HttpSOAPConnection
extends SOAPConnection {
    public static final String vmVendor = SAAJUtil.getSystemProperty("java.vendor.url");
    private static final String sunVmVendor = "http://java.sun.com/";
    private static final String ibmVmVendor = "http://www.ibm.com/";
    private static final boolean isSunVM = "http://java.sun.com/".equals(vmVendor);
    private static final boolean isIBMVM = "http://www.ibm.com/".equals(vmVendor);
    private static final String JAXM_URLENDPOINT = "javax.xml.messaging.URLEndpoint";
    protected static final Logger log = Logger.getLogger("com.sun.xml.internal.messaging.saaj.client.p2p", "com.sun.xml.internal.messaging.saaj.client.p2p.LocalStrings");
    MessageFactory messageFactory = null;
    boolean closed = false;
    private static final String SSL_PKG;
    private static final String SSL_PROVIDER;
    private static final int dL = 0;

    public HttpSOAPConnection() throws SOAPException {
        try {
            this.messageFactory = MessageFactory.newInstance("Dynamic Protocol");
        }
        catch (NoSuchMethodError noSuchMethodError) {
            this.messageFactory = MessageFactory.newInstance();
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "SAAJ0001.p2p.cannot.create.msg.factory", exception);
            throw new SOAPExceptionImpl("Unable to create message factory", exception);
        }
    }

    @Override
    public void close() throws SOAPException {
        if (this.closed) {
            log.severe("SAAJ0002.p2p.close.already.closed.conn");
            throw new SOAPExceptionImpl("Connection already closed");
        }
        this.messageFactory = null;
        this.closed = true;
    }

    @Override
    public SOAPMessage call(SOAPMessage sOAPMessage, Object object) throws SOAPException {
        Object object2;
        Class<?> clazz;
        block14: {
            if (this.closed) {
                log.severe("SAAJ0003.p2p.call.already.closed.conn");
                throw new SOAPExceptionImpl("Connection is closed");
            }
            clazz = null;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                clazz = classLoader != null ? classLoader.loadClass(JAXM_URLENDPOINT) : Class.forName(JAXM_URLENDPOINT);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!log.isLoggable(Level.FINEST)) break block14;
                log.finest("SAAJ0090.p2p.endpoint.available.only.for.JAXM");
            }
        }
        if (clazz != null && clazz.isInstance(object)) {
            object2 = null;
            try {
                Method method = clazz.getMethod("getURL", null);
                object2 = (String)method.invoke(object, null);
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "SAAJ0004.p2p.internal.err", exception);
                throw new SOAPExceptionImpl("Internal error: " + exception.getMessage());
            }
            try {
                object = new URL((String)object2);
            }
            catch (MalformedURLException malformedURLException) {
                log.log(Level.SEVERE, "SAAJ0005.p2p.", malformedURLException);
                throw new SOAPExceptionImpl("Bad URL: " + malformedURLException.getMessage());
            }
        }
        if (object instanceof String) {
            try {
                object = new URL((String)object);
            }
            catch (MalformedURLException malformedURLException) {
                log.log(Level.SEVERE, "SAAJ0006.p2p.bad.URL", malformedURLException);
                throw new SOAPExceptionImpl("Bad URL: " + malformedURLException.getMessage());
            }
        }
        if (object instanceof URL) {
            try {
                object2 = this.post(sOAPMessage, (URL)object);
                return object2;
            }
            catch (Exception exception) {
                throw new SOAPExceptionImpl(exception);
            }
        }
        log.severe("SAAJ0007.p2p.bad.endPoint.type");
        throw new SOAPExceptionImpl("Bad endPoint type " + object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SOAPMessage post(SOAPMessage sOAPMessage, URL uRL) throws SOAPException, IOException {
        Object object;
        Object object2;
        MimeHeaders mimeHeaders;
        Object object3;
        Object object4;
        int n;
        HttpURLConnection httpURLConnection;
        boolean bl;
        block35: {
            bl = false;
            URL uRL2 = null;
            httpURLConnection = null;
            n = 0;
            try {
                Object object5;
                if (uRL.getProtocol().equals("https")) {
                    this.initHttps();
                }
                object4 = new URI(uRL.toString());
                object3 = ((URI)object4).getRawUserInfo();
                uRL2 = uRL;
                if (!uRL2.getProtocol().equalsIgnoreCase("http") && !uRL2.getProtocol().equalsIgnoreCase("https")) {
                    log.severe("SAAJ0052.p2p.protocol.mustbe.http.or.https");
                    throw new IllegalArgumentException("Protocol " + uRL2.getProtocol() + " not supported in URL " + uRL2);
                }
                httpURLConnection = this.createConnection(uRL2);
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setDoInput(true);
                httpURLConnection.setUseCaches(false);
                httpURLConnection.setInstanceFollowRedirects(true);
                if (sOAPMessage.saveRequired()) {
                    sOAPMessage.saveChanges();
                }
                mimeHeaders = sOAPMessage.getMimeHeaders();
                object2 = mimeHeaders.getAllHeaders();
                boolean bl2 = false;
                while (object2.hasNext()) {
                    object5 = (MimeHeader)object2.next();
                    object = mimeHeaders.getHeader(((MimeHeader)object5).getName());
                    if (((String[])object).length == 1) {
                        httpURLConnection.setRequestProperty(((MimeHeader)object5).getName(), ((MimeHeader)object5).getValue());
                    } else {
                        StringBuffer stringBuffer = new StringBuffer();
                        for (int i = 0; i < ((String[])object).length; ++i) {
                            if (i != 0) {
                                stringBuffer.append(',');
                            }
                            stringBuffer.append(object[i]);
                        }
                        httpURLConnection.setRequestProperty(((MimeHeader)object5).getName(), stringBuffer.toString());
                    }
                    if (!"Authorization".equals(((MimeHeader)object5).getName())) continue;
                    bl2 = true;
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("SAAJ0091.p2p.https.auth.in.POST.true");
                }
                if (!bl2 && object3 != null) {
                    this.initAuthUserInfo(httpURLConnection, (String)object3);
                }
                object5 = httpURLConnection.getOutputStream();
                try {
                    sOAPMessage.writeTo((OutputStream)object5);
                    ((OutputStream)object5).flush();
                }
                finally {
                    ((OutputStream)object5).close();
                }
                httpURLConnection.connect();
                try {
                    n = httpURLConnection.getResponseCode();
                    if (n == 500) {
                        bl = true;
                    } else if (n / 100 != 2) {
                        log.log(Level.SEVERE, "SAAJ0008.p2p.bad.response", new String[]{httpURLConnection.getResponseMessage()});
                        throw new SOAPExceptionImpl("Bad response: (" + n + httpURLConnection.getResponseMessage());
                    }
                }
                catch (IOException iOException) {
                    n = httpURLConnection.getResponseCode();
                    if (n == 500) {
                        bl = true;
                        break block35;
                    }
                    throw iOException;
                }
            }
            catch (SOAPException sOAPException) {
                throw sOAPException;
            }
            catch (Exception exception) {
                log.severe("SAAJ0009.p2p.msg.send.failed");
                throw new SOAPExceptionImpl("Message send failed", exception);
            }
        }
        object4 = null;
        object3 = null;
        if (n == 200 || bl) {
            try {
                int n2;
                mimeHeaders = new MimeHeaders();
                int n3 = 1;
                while (true) {
                    object2 = httpURLConnection.getHeaderFieldKey(n3);
                    String string = httpURLConnection.getHeaderField(n3);
                    if (object2 == null && string == null) break;
                    if (object2 != null) {
                        object = new StringTokenizer(string, ",");
                        while (((StringTokenizer)object).hasMoreTokens()) {
                            mimeHeaders.addHeader((String)object2, ((StringTokenizer)object).nextToken().trim());
                        }
                    }
                    ++n3;
                }
                object3 = bl ? httpURLConnection.getErrorStream() : httpURLConnection.getInputStream();
                object = this.readFully((InputStream)object3);
                int n4 = n2 = httpURLConnection.getContentLength() == -1 ? ((Object)object).length : httpURLConnection.getContentLength();
                if (n2 == 0) {
                    object4 = null;
                    log.warning("SAAJ0014.p2p.content.zero");
                } else {
                    ByteInputStream byteInputStream = new ByteInputStream((byte[])object, n2);
                    object4 = this.messageFactory.createMessage(mimeHeaders, byteInputStream);
                }
            }
            catch (SOAPException sOAPException) {
                throw sOAPException;
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "SAAJ0010.p2p.cannot.read.resp", exception);
                throw new SOAPExceptionImpl("Unable to read response: " + exception.getMessage());
            }
            finally {
                if (object3 != null) {
                    ((InputStream)object3).close();
                }
                httpURLConnection.disconnect();
            }
        }
        return object4;
    }

    @Override
    public SOAPMessage get(Object object) throws SOAPException {
        Object object2;
        if (this.closed) {
            log.severe("SAAJ0011.p2p.get.already.closed.conn");
            throw new SOAPExceptionImpl("Connection is closed");
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(JAXM_URLENDPOINT);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz != null && clazz.isInstance(object)) {
            object2 = null;
            try {
                Method method = clazz.getMethod("getURL", null);
                object2 = (String)method.invoke(object, null);
            }
            catch (Exception exception) {
                log.severe("SAAJ0004.p2p.internal.err");
                throw new SOAPExceptionImpl("Internal error: " + exception.getMessage());
            }
            try {
                object = new URL((String)object2);
            }
            catch (MalformedURLException malformedURLException) {
                log.severe("SAAJ0005.p2p.");
                throw new SOAPExceptionImpl("Bad URL: " + malformedURLException.getMessage());
            }
        }
        if (object instanceof String) {
            try {
                object = new URL((String)object);
            }
            catch (MalformedURLException malformedURLException) {
                log.severe("SAAJ0006.p2p.bad.URL");
                throw new SOAPExceptionImpl("Bad URL: " + malformedURLException.getMessage());
            }
        }
        if (object instanceof URL) {
            try {
                object2 = this.doGet((URL)object);
                return object2;
            }
            catch (Exception exception) {
                throw new SOAPExceptionImpl(exception);
            }
        }
        throw new SOAPExceptionImpl("Bad endPoint type " + object);
    }

    SOAPMessage doGet(URL uRL) throws SOAPException, IOException {
        Object object;
        Object object2;
        int n;
        HttpURLConnection httpURLConnection;
        boolean bl;
        block24: {
            bl = false;
            URL uRL2 = null;
            httpURLConnection = null;
            n = 0;
            try {
                if (uRL.getProtocol().equals("https")) {
                    this.initHttps();
                }
                object2 = new URI(uRL.toString());
                object = ((URI)object2).getRawUserInfo();
                uRL2 = uRL;
                if (!uRL2.getProtocol().equalsIgnoreCase("http") && !uRL2.getProtocol().equalsIgnoreCase("https")) {
                    log.severe("SAAJ0052.p2p.protocol.mustbe.http.or.https");
                    throw new IllegalArgumentException("Protocol " + uRL2.getProtocol() + " not supported in URL " + uRL2);
                }
                httpURLConnection = this.createConnection(uRL2);
                httpURLConnection.setRequestMethod("GET");
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setDoInput(true);
                httpURLConnection.setUseCaches(false);
                HttpURLConnection.setFollowRedirects(true);
                httpURLConnection.connect();
                try {
                    n = httpURLConnection.getResponseCode();
                    if (n == 500) {
                        bl = true;
                    } else if (n / 100 != 2) {
                        log.log(Level.SEVERE, "SAAJ0008.p2p.bad.response", new String[]{httpURLConnection.getResponseMessage()});
                        throw new SOAPExceptionImpl("Bad response: (" + n + httpURLConnection.getResponseMessage());
                    }
                }
                catch (IOException iOException) {
                    n = httpURLConnection.getResponseCode();
                    if (n == 500) {
                        bl = true;
                        break block24;
                    }
                    throw iOException;
                }
            }
            catch (SOAPException sOAPException) {
                throw sOAPException;
            }
            catch (Exception exception) {
                log.severe("SAAJ0012.p2p.get.failed");
                throw new SOAPExceptionImpl("Get failed", exception);
            }
        }
        object2 = null;
        object = null;
        if (n == 200 || bl) {
            try {
                MimeHeaders mimeHeaders = new MimeHeaders();
                int n2 = 1;
                while (true) {
                    String string = httpURLConnection.getHeaderFieldKey(n2);
                    String string2 = httpURLConnection.getHeaderField(n2);
                    if (string == null && string2 == null) break;
                    if (string != null) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                        while (stringTokenizer.hasMoreTokens()) {
                            mimeHeaders.addHeader(string, stringTokenizer.nextToken().trim());
                        }
                    }
                    ++n2;
                }
                Object object3 = object = bl ? httpURLConnection.getErrorStream() : httpURLConnection.getInputStream();
                if (object == null || httpURLConnection.getContentLength() == 0 || ((InputStream)object).available() == 0) {
                    object2 = null;
                    log.warning("SAAJ0014.p2p.content.zero");
                } else {
                    object2 = this.messageFactory.createMessage(mimeHeaders, (InputStream)object);
                }
            }
            catch (SOAPException sOAPException) {
                throw sOAPException;
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "SAAJ0010.p2p.cannot.read.resp", exception);
                throw new SOAPExceptionImpl("Unable to read response: " + exception.getMessage());
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
                httpURLConnection.disconnect();
            }
        }
        return object2;
    }

    private byte[] readFully(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        return byArray2;
    }

    private void initHttps() {
        String string = SAAJUtil.getSystemProperty("java.protocol.handler.pkgs");
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "SAAJ0053.p2p.providers", new String[]{string});
        }
        if (string == null || string.indexOf(SSL_PKG) < 0) {
            string = string == null ? SSL_PKG : string + "|" + SSL_PKG;
            System.setProperty("java.protocol.handler.pkgs", string);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "SAAJ0054.p2p.set.providers", new String[]{string});
            }
            try {
                Class<?> clazz = Class.forName(SSL_PROVIDER);
                Provider provider = (Provider)clazz.newInstance();
                Security.addProvider(provider);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "SAAJ0055.p2p.added.ssl.provider", new String[]{SSL_PROVIDER});
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void initAuthUserInfo(HttpURLConnection httpURLConnection, String string) {
        if (string != null) {
            String string2;
            String string3;
            int n = string.indexOf(58);
            if (n == -1) {
                string3 = ParseUtil.decode(string);
                string2 = null;
            } else {
                string3 = ParseUtil.decode(string.substring(0, n++));
                string2 = ParseUtil.decode(string.substring(n));
            }
            String string4 = string3 + ":";
            byte[] byArray = string4.getBytes();
            byte[] byArray2 = string2.getBytes();
            byte[] byArray3 = new byte[byArray.length + byArray2.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
            String string5 = "Basic " + new String(Base64.encode(byArray3));
            httpURLConnection.setRequestProperty("Authorization", string5);
        }
    }

    private void d(String string) {
        log.log(Level.SEVERE, "SAAJ0013.p2p.HttpSOAPConnection", new String[]{string});
        System.err.println("HttpSOAPConnection: " + string);
    }

    private HttpURLConnection createConnection(URL uRL) throws IOException {
        return (HttpURLConnection)uRL.openConnection();
    }

    static {
        if (isIBMVM) {
            SSL_PKG = "com.ibm.net.ssl.internal.www.protocol";
            SSL_PROVIDER = "com.ibm.net.ssl.internal.ssl.Provider";
        } else {
            SSL_PKG = "com.sun.net.ssl.internal.www.protocol";
            SSL_PROVIDER = "com.sun.net.ssl.internal.ssl.Provider";
        }
    }
}

