/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.soap;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.datatransfer.DataFlavor;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.imageio.ImageIO;

public class JpegDataContentHandler
extends Component
implements DataContentHandler {
    public static final String STR_SRC = "java.awt.Image";

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray = new DataFlavor[1];
        try {
            dataFlavorArray[0] = new ActivationDataFlavor(Class.forName(STR_SRC), "image/jpeg", "JPEG");
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return dataFlavorArray;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor, DataSource dataSource) {
        if (dataFlavor.getMimeType().startsWith("image/jpeg") && dataFlavor.getRepresentationClass().getName().equals(STR_SRC)) {
            InputStream inputStream = null;
            BufferedImage bufferedImage = null;
            try {
                inputStream = dataSource.getInputStream();
                bufferedImage = ImageIO.read(inputStream);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            return bufferedImage;
        }
        return null;
    }

    @Override
    public Object getContent(DataSource dataSource) {
        InputStream inputStream = null;
        BufferedImage bufferedImage = null;
        try {
            inputStream = dataSource.getInputStream();
            bufferedImage = ImageIO.read(inputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bufferedImage;
    }

    @Override
    public void writeTo(Object object, String string, OutputStream outputStream) throws IOException {
        if (!string.equals("image/jpeg")) {
            throw new IOException("Invalid content type \"" + string + "\" for ImageContentHandler");
        }
        if (object == null) {
            throw new IOException("Null object for ImageContentHandler");
        }
        try {
            BufferedImage bufferedImage = null;
            if (object instanceof BufferedImage) {
                bufferedImage = (BufferedImage)object;
            } else {
                Image image = (Image)object;
                MediaTracker mediaTracker = new MediaTracker(this);
                mediaTracker.addImage(image, 0);
                mediaTracker.waitForAll();
                if (mediaTracker.isErrorAny()) {
                    throw new IOException("Error while loading image");
                }
                bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.drawImage(image, 0, 0, null);
            }
            ImageIO.write((RenderedImage)bufferedImage, "jpeg", outputStream);
        }
        catch (Exception exception) {
            throw new IOException("Unable to run the JPEG Encoder on a stream " + exception.getMessage());
        }
    }
}

