/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import javax.annotation.Resource;
import javax.xml.ws.WebServiceException;

public abstract class InjectionPlan<T, R> {
    public abstract void inject(T var1, R var2);

    public void inject(T t, Callable<R> callable) {
        try {
            this.inject(t, callable.call());
        }
        catch (Exception exception) {
            throw new WebServiceException(exception);
        }
    }

    private static void invokeMethod(final Method method, final Object object, final Object ... objectArray) {
        if (method == null) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    method.invoke(object, objectArray);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new WebServiceException(illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new WebServiceException(invocationTargetException);
                }
                return null;
            }
        });
    }

    public static <T, R> InjectionPlan<T, R> buildInjectionPlan(Class<? extends T> clazz, Class<R> clazz2, boolean bl) {
        Resource resource;
        Class<T> clazz3;
        ArrayList arrayList = new ArrayList();
        for (clazz3 = clazz; clazz3 != Object.class; clazz3 = clazz3.getSuperclass()) {
            for (AccessibleObject accessibleObject : clazz3.getDeclaredFields()) {
                resource = ((Field)accessibleObject).getAnnotation(Resource.class);
                if (resource == null || !InjectionPlan.isInjectionPoint(resource, ((Field)accessibleObject).getType(), "Incorrect type for field" + ((Field)accessibleObject).getName(), clazz2)) continue;
                if (bl && !Modifier.isStatic(((Field)accessibleObject).getModifiers())) {
                    throw new WebServiceException("Static resource " + clazz2 + " cannot be injected to non-static " + accessibleObject);
                }
                arrayList.add(new FieldInjectionPlan((Field)accessibleObject));
            }
        }
        for (clazz3 = clazz; clazz3 != Object.class; clazz3 = clazz3.getSuperclass()) {
            for (AccessibleObject accessibleObject : clazz3.getDeclaredMethods()) {
                resource = ((Method)accessibleObject).getAnnotation(Resource.class);
                if (resource == null) continue;
                Class<?>[] classArray = ((Method)accessibleObject).getParameterTypes();
                if (classArray.length != 1) {
                    throw new WebServiceException("Incorrect no of arguments for method " + accessibleObject);
                }
                if (!InjectionPlan.isInjectionPoint(resource, classArray[0], "Incorrect argument types for method" + ((Method)accessibleObject).getName(), clazz2)) continue;
                if (bl && !Modifier.isStatic(((Method)accessibleObject).getModifiers())) {
                    throw new WebServiceException("Static resource " + clazz2 + " cannot be injected to non-static " + accessibleObject);
                }
                arrayList.add(new MethodInjectionPlan((Method)accessibleObject));
            }
        }
        return new Compositor(arrayList);
    }

    private static boolean isInjectionPoint(Resource resource, Class clazz, String string, Class clazz2) {
        Class<?> clazz3 = resource.type();
        if (clazz3.equals(Object.class)) {
            return clazz.equals(clazz2);
        }
        if (clazz3.equals(clazz2)) {
            if (clazz.isAssignableFrom(clazz2)) {
                return true;
            }
            throw new WebServiceException(string);
        }
        return false;
    }

    private static class Compositor<T, R>
    extends InjectionPlan<T, R> {
        private final Collection<InjectionPlan<T, R>> children;

        public Compositor(Collection<InjectionPlan<T, R>> collection) {
            this.children = collection;
        }

        @Override
        public void inject(T t, R r) {
            for (InjectionPlan<T, R> injectionPlan : this.children) {
                injectionPlan.inject(t, r);
            }
        }

        @Override
        public void inject(T t, Callable<R> callable) {
            if (!this.children.isEmpty()) {
                super.inject(t, callable);
            }
        }
    }

    public static class FieldInjectionPlan<T, R>
    extends InjectionPlan<T, R> {
        private final Field field;

        public FieldInjectionPlan(Field field) {
            this.field = field;
        }

        @Override
        public void inject(final T t, final R r) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        if (!field.isAccessible()) {
                            field.setAccessible(true);
                        }
                        field.set(t, r);
                        return null;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new WebServiceException(illegalAccessException);
                    }
                }
            });
        }
    }

    public static class MethodInjectionPlan<T, R>
    extends InjectionPlan<T, R> {
        private final Method method;

        public MethodInjectionPlan(Method method) {
            this.method = method;
        }

        @Override
        public void inject(T t, R r) {
            InjectionPlan.invokeMethod(this.method, t, new Object[]{r});
        }
    }
}

