/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollPaneUI;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;
import javax.swing.text.JTextComponent;

public class SynthScrollPaneUI
extends BasicScrollPaneUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;
    private boolean viewportViewHasFocus = false;
    private ViewportViewFocusHandler viewportViewFocusHandler;

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthScrollPaneUI();
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintScrollPaneBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        Border border = this.scrollpane.getViewportBorder();
        if (border != null) {
            Rectangle rectangle = this.scrollpane.getViewportBorderBounds();
            border.paintBorder(this.scrollpane, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    @Override
    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        synthContext.getPainter().paintScrollPaneBorder(synthContext, graphics, n, n2, n3, n4);
    }

    @Override
    protected void installDefaults(JScrollPane jScrollPane) {
        this.updateStyle(jScrollPane);
    }

    private void updateStyle(JScrollPane jScrollPane) {
        SynthContext synthContext = this.getContext(jScrollPane, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            Border border = this.scrollpane.getViewportBorder();
            if (border == null || border instanceof UIResource) {
                this.scrollpane.setViewportBorder(new ViewportBorder(synthContext));
            }
            if (synthStyle != null) {
                this.uninstallKeyboardActions(jScrollPane);
                this.installKeyboardActions(jScrollPane);
            }
        }
        synthContext.dispose();
    }

    @Override
    protected void installListeners(JScrollPane jScrollPane) {
        super.installListeners(jScrollPane);
        jScrollPane.addPropertyChangeListener(this);
        if (UIManager.getBoolean("ScrollPane.useChildTextComponentFocus")) {
            this.viewportViewFocusHandler = new ViewportViewFocusHandler();
            jScrollPane.getViewport().addContainerListener(this.viewportViewFocusHandler);
            Component component = jScrollPane.getViewport().getView();
            if (component instanceof JTextComponent) {
                component.addFocusListener(this.viewportViewFocusHandler);
            }
        }
    }

    @Override
    protected void uninstallDefaults(JScrollPane jScrollPane) {
        SynthContext synthContext = this.getContext(jScrollPane, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        if (this.scrollpane.getViewportBorder() instanceof UIResource) {
            this.scrollpane.setViewportBorder(null);
        }
    }

    @Override
    protected void uninstallListeners(JComponent jComponent) {
        super.uninstallListeners(jComponent);
        jComponent.removePropertyChangeListener(this);
        if (this.viewportViewFocusHandler != null) {
            JViewport jViewport = ((JScrollPane)jComponent).getViewport();
            jViewport.removeContainerListener(this.viewportViewFocusHandler);
            if (jViewport.getView() != null) {
                jViewport.getView().removeFocusListener(this.viewportViewFocusHandler);
            }
            this.viewportViewFocusHandler = null;
        }
    }

    @Override
    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(jComponent, this.style, n);
    }

    private int getComponentState(JComponent jComponent) {
        int n = SynthLookAndFeel.getComponentState(jComponent);
        if (this.viewportViewFocusHandler != null && this.viewportViewHasFocus) {
            n |= 0x100;
        }
        return n;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle(this.scrollpane);
        }
    }

    private class ViewportBorder
    extends AbstractBorder
    implements UIResource {
        private Insets insets;

        ViewportBorder(SynthContext synthContext) {
            this.insets = (Insets)synthContext.getStyle().get(synthContext, "ScrollPane.viewportBorderInsets");
            if (this.insets == null) {
                this.insets = SynthLookAndFeel.EMPTY_UIRESOURCE_INSETS;
            }
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JComponent jComponent = (JComponent)component;
            SynthContext synthContext = SynthScrollPaneUI.this.getContext(jComponent);
            SynthStyle synthStyle = synthContext.getStyle();
            if (synthStyle == null) {
                assert (false) : "SynthBorder is being used outside after the  UI has been uninstalled";
                return;
            }
            synthContext.getPainter().paintViewportBorder(synthContext, graphics, n, n2, n3, n4);
            synthContext.dispose();
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            if (insets == null) {
                return new Insets(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
            }
            insets.top = this.insets.top;
            insets.bottom = this.insets.bottom;
            insets.left = this.insets.left;
            insets.right = this.insets.left;
            return insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    private class ViewportViewFocusHandler
    implements ContainerListener,
    FocusListener {
        private ViewportViewFocusHandler() {
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            if (containerEvent.getChild() instanceof JTextComponent) {
                containerEvent.getChild().addFocusListener(this);
                SynthScrollPaneUI.this.viewportViewHasFocus = containerEvent.getChild().isFocusOwner();
                SynthScrollPaneUI.this.scrollpane.repaint();
            }
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            if (containerEvent.getChild() instanceof JTextComponent) {
                containerEvent.getChild().removeFocusListener(this);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            SynthScrollPaneUI.this.viewportViewHasFocus = true;
            SynthScrollPaneUI.this.scrollpane.repaint();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            SynthScrollPaneUI.this.viewportViewHasFocus = false;
            SynthScrollPaneUI.this.scrollpane.repaint();
        }
    }
}

