/*
 * Decompiled with CFR 0.152.
 */
package sun.usagetracker;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;

public final class UsageTrackerClient {
    private static final Object LOCK = new Object();
    private static final String ORCL_UT_CONFIG_FILE_NAME = "usagetracker.properties";
    private static final String ORCL_UT_USAGE_DIR = ".oracle_jre_usage";
    private static final String ORCL_UT_PROPERTY_NAME = "com.oracle.usagetracker.";
    private static final String ORCL_UT_PROPERTY_RUN_SYNCHRONOUSLY = "com.oracle.usagetracker.run.synchronous";
    private static final String ORCL_UT_PROPERTY_CONFIG_FILE_NAME = "com.oracle.usagetracker.config.file";
    private static final String ORCL_UT_LOGTOFILE = "com.oracle.usagetracker.logToFile";
    private static final String ORCL_UT_LOGFILEMAXSIZE = "com.oracle.usagetracker.logFileMaxSize";
    private static final String ORCL_UT_LOGTOUDP = "com.oracle.usagetracker.logToUDP";
    private static final String ORCL_UT_TRACK_LAST_USAGE = "com.oracle.usagetracker.track.last.usage";
    private static final String ORCL_UT_VERBOSE = "com.oracle.usagetracker.verbose";
    private static final String ORCL_UT_DEBUG = "com.oracle.usagetracker.debug";
    private static final String ORCL_UT_ADDITIONALPROPERTIES = "com.oracle.usagetracker.additionalProperties";
    private static final String ORCL_UT_SEPARATOR = "com.oracle.usagetracker.separator";
    private static final String ORCL_UT_QUOTE = "com.oracle.usagetracker.quote";
    private static final String ORCL_UT_QUOTE_INNER = "com.oracle.usagetracker.innerQuote";
    private static final String DEFAULT_SEP = ",";
    private static final String DEFAULT_QUOTE = "\"";
    private static final String DEFAULT_QUOTE_INNER = "'";
    private static final AtomicBoolean isFirstRun = new AtomicBoolean(true);
    private static final String javaHome = UsageTrackerClient.getPropertyPrivileged("java.home");
    private static final String userHomeKeyword = "${user.home}";
    private static String separator;
    private static String quote;
    private static String innerQuote;
    private static boolean enabled;
    private static boolean verbose;
    private static boolean debug;
    private static boolean trackTime;
    private static String[] additionalProperties;
    private static String fullLogFilename;
    private static long logFileMaxSize;
    private static String datagramHost;
    private static int datagramPort;
    private static String staticMessage;

    private static String getPropertyPrivileged(String string) {
        return UsageTrackerClient.getPropertyPrivileged(string, null);
    }

    private static String getPropertyPrivileged(final String string, final String string2) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(string, string2);
            }
        });
    }

    private static String getEnvPrivileged(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getenv(string);
            }
        });
    }

    private static File getConfigFilePrivileged() {
        File file = null;
        String[] stringArray = new String[]{UsageTrackerClient.getPropertyPrivileged(ORCL_UT_PROPERTY_CONFIG_FILE_NAME), UsageTrackerClient.getOSSpecificConfigFilePath(), javaHome + File.separator + "lib" + File.separator + "management" + File.separator + ORCL_UT_CONFIG_FILE_NAME};
        for (final String string : stringArray) {
            if (string != null && (file = AccessController.doPrivileged(new PrivilegedAction<File>(){

                @Override
                public File run() {
                    File file = new File(string);
                    return file.exists() ? file : null;
                }
            })) != null) break;
        }
        return file;
    }

    private static String getOSSpecificConfigFilePath() {
        String string = UsageTrackerClient.getPropertyPrivileged("os.name");
        if (string != null) {
            if (string.toLowerCase().startsWith("sunos")) {
                return "/etc/oracle/java/usagetracker.properties";
            }
            if (string.toLowerCase().startsWith("mac")) {
                return "/Library/Application Support/Oracle/Java/usagetracker.properties";
            }
            if (string.toLowerCase().startsWith("win")) {
                String string2 = UsageTrackerClient.getEnvPrivileged("ProgramFiles");
                return string2 == null ? null : string2 + "\\Java\\conf\\" + ORCL_UT_CONFIG_FILE_NAME;
            }
            if (string.toLowerCase().startsWith("linux")) {
                return "/etc/oracle/java/usagetracker.properties";
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getFullLogFilename(Properties properties) {
        String string = properties.getProperty(ORCL_UT_LOGTOFILE, "");
        if (string.isEmpty()) {
            return null;
        }
        if (string.startsWith(userHomeKeyword)) {
            if (string.length() > userHomeKeyword.length()) {
                return UsageTrackerClient.getPropertyPrivileged("user.home") + string.substring(userHomeKeyword.length());
            }
            this.printVerbose("UsageTracker: blank filename after user.home.");
            return null;
        }
        if (new File(string).isAbsolute()) return string;
        this.printVerbose("UsageTracker: relative path disallowed.");
        return null;
    }

    private long getLogFileMaxSize(Properties properties) {
        String string = properties.getProperty(ORCL_UT_LOGFILEMAXSIZE, "");
        if (!string.isEmpty()) {
            try {
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.printVerbose("UsageTracker: bad maximum file size.");
            }
        }
        return -1L;
    }

    private String[] getAdditionalProperties(Properties properties) {
        String string = properties.getProperty(ORCL_UT_ADDITIONALPROPERTIES, "");
        return string.isEmpty() ? new String[]{} : string.split(DEFAULT_SEP);
    }

    private String parseDatagramHost(String string) {
        if (string != null) {
            int n = string.indexOf(58);
            if (n > 0 && n < string.length() - 1) {
                return string.substring(0, n);
            }
            this.printVerbose("UsageTracker: bad UDP details.");
        }
        return null;
    }

    private int parseDatagramPort(String string) {
        if (string != null) {
            int n = string.indexOf(58);
            try {
                return Integer.parseInt(string.substring(n + 1));
            }
            catch (Exception exception) {
                this.printVerbose("UsageTracker: bad UDP port.");
            }
        }
        return 0;
    }

    private void printVerbose(String string) {
        if (verbose) {
            System.err.println(string);
        }
    }

    private void printDebug(String string) {
        if (debug) {
            System.err.println(string);
        }
    }

    private void printDebugStackTrace(Throwable throwable) {
        if (debug) {
            throwable.printStackTrace();
        }
    }

    private void setupAndTimestamp(long l) {
        if (isFirstRun.compareAndSet(true, false)) {
            File file = UsageTrackerClient.getConfigFilePrivileged();
            if (file != null) {
                this.setup(file);
            }
            if (trackTime) {
                this.registerUsage(l);
            }
        }
    }

    public void run(final String string, final String string2) {
        this.printDebug("UsageTracker.run: " + string + ", javaCommand: " + string2);
        try {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    long l = System.currentTimeMillis();
                    boolean bl = Boolean.parseBoolean(System.getProperty(UsageTrackerClient.ORCL_UT_PROPERTY_RUN_SYNCHRONOUSLY, "true"));
                    if (bl) {
                        UsageTrackerClient.this.setupAndTimestamp(l);
                        UsageTrackerClient.this.printVerbose("UsageTracker: running synchronous.");
                    }
                    if (enabled || !bl) {
                        UsageTrackerRunnable usageTrackerRunnable = new UsageTrackerRunnable(string, string2, l, !bl);
                        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                        while (threadGroup.getParent() != null) {
                            threadGroup = threadGroup.getParent();
                        }
                        Thread thread = new Thread(threadGroup, usageTrackerRunnable, "UsageTracker");
                        thread.setDaemon(true);
                        thread.start();
                    }
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            this.printVerbose("UsageTracker: error in starting thread.");
            this.printDebugStackTrace(throwable);
        }
    }

    private boolean getBooleanProperty(Properties properties, String string) {
        return Boolean.parseBoolean(properties.getProperty(string));
    }

    private void setup(File file) {
        Object object;
        Properties properties = new Properties();
        if (file != null) {
            try {
                object = new FileInputStream(file);
                Throwable throwable = null;
                try (BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object);){
                    properties.load(bufferedInputStream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                ((FileInputStream)object).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((FileInputStream)object).close();
                        }
                    }
                }
            }
            catch (Exception exception) {
                properties.clear();
            }
        }
        verbose = this.getBooleanProperty(properties, ORCL_UT_VERBOSE);
        debug = this.getBooleanProperty(properties, ORCL_UT_DEBUG);
        separator = properties.getProperty(ORCL_UT_SEPARATOR, DEFAULT_SEP);
        quote = properties.getProperty(ORCL_UT_QUOTE, DEFAULT_QUOTE);
        innerQuote = properties.getProperty(ORCL_UT_QUOTE_INNER, DEFAULT_QUOTE_INNER);
        fullLogFilename = this.getFullLogFilename(properties);
        logFileMaxSize = this.getLogFileMaxSize(properties);
        additionalProperties = this.getAdditionalProperties(properties);
        object = properties.getProperty(ORCL_UT_LOGTOUDP);
        datagramHost = this.parseDatagramHost((String)object);
        datagramPort = this.parseDatagramPort((String)object);
        enabled = fullLogFilename != null || datagramHost != null && datagramPort > 0;
        trackTime = Boolean.parseBoolean(properties.getProperty(ORCL_UT_TRACK_LAST_USAGE, "true"));
    }

    private void registerUsage(long l) {
        block18: {
            try {
                String string = new File(System.getProperty("java.home")).getCanonicalPath();
                String string2 = System.getProperty("user.home");
                if (string2 == null) break block18;
                File file = new File(string2 + File.separator + ORCL_UT_USAGE_DIR, this.getPathHash(string) + ".timestamp");
                if (!file.exists()) {
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    file.createNewFile();
                }
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    String string3 = string + System.lineSeparator() + l + System.lineSeparator();
                    fileOutputStream.write(string3.getBytes("UTF-8"));
                }
                catch (IOException iOException) {
                    this.printDebugStackTrace(iOException);
                }
            }
            catch (IOException iOException) {
                this.printDebugStackTrace(iOException);
            }
        }
    }

    private String getPathHash(String string) {
        long l = 0L;
        for (int i = 0; i < string.length(); ++i) {
            l = 31L * l + (long)string.charAt(i);
        }
        return Long.toHexString(l);
    }

    static {
        trackTime = true;
    }

    class UsageTrackerRunnable
    implements Runnable {
        private String callerName;
        private String javaCommand;
        private long timestamp;
        private boolean runAsync;

        UsageTrackerRunnable(String string, String string2, long l, boolean bl) {
            this.callerName = string;
            this.javaCommand = string2 != null ? string2 : "";
            this.timestamp = l;
            this.runAsync = bl;
        }

        private String buildMessage(String string, String string2, long l) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendWithQuotes(stringBuilder, string);
            stringBuilder.append(separator);
            Date date = new Date(l);
            this.appendWithQuotes(stringBuilder, date.toString());
            stringBuilder.append(separator);
            String string3 = "0";
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                string3 = inetAddress.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.appendWithQuotes(stringBuilder, string3);
            stringBuilder.append(separator);
            this.appendWithQuotes(stringBuilder, string2);
            stringBuilder.append(separator);
            stringBuilder.append(this.getRuntimeDetails());
            stringBuilder.append("\n");
            return stringBuilder.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getRuntimeDetails() {
            Object object = LOCK;
            synchronized (object) {
                if (staticMessage == null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    this.appendWithQuotes(stringBuilder, javaHome);
                    stringBuilder.append(separator);
                    this.appendWithQuotes(stringBuilder, UsageTrackerClient.getPropertyPrivileged("java.version"));
                    stringBuilder.append(separator);
                    this.appendWithQuotes(stringBuilder, UsageTrackerClient.getPropertyPrivileged("java.vm.version"));
                    stringBuilder.append(separator);
                    this.appendWithQuotes(stringBuilder, UsageTrackerClient.getPropertyPrivileged("java.vendor"));
                    stringBuilder.append(separator);
                    this.appendWithQuotes(stringBuilder, UsageTrackerClient.getPropertyPrivileged("java.vm.vendor"));
                    stringBuilder.append(separator);
                    this.appendWithQuotes(stringBuilder, UsageTrackerClient.getPropertyPrivileged("os.name"));
                    stringBuilder.append(separator);
                    this.appendWithQuotes(stringBuilder, UsageTrackerClient.getPropertyPrivileged("os.arch"));
                    stringBuilder.append(separator);
                    this.appendWithQuotes(stringBuilder, UsageTrackerClient.getPropertyPrivileged("os.version"));
                    stringBuilder.append(separator);
                    List<String> list = this.getInputArguments();
                    StringBuilder stringBuilder2 = new StringBuilder();
                    for (String stringArray : list) {
                        stringBuilder2.append(this.addQuotesFor(stringArray, " ", innerQuote));
                        stringBuilder2.append(' ');
                    }
                    this.appendWithQuotes(stringBuilder, stringBuilder2.toString());
                    stringBuilder.append(separator);
                    this.appendWithQuotes(stringBuilder, UsageTrackerClient.getPropertyPrivileged("java.class.path"));
                    stringBuilder.append(separator);
                    StringBuilder stringBuilder3 = new StringBuilder();
                    for (String string : additionalProperties) {
                        stringBuilder3.append(string.trim());
                        stringBuilder3.append("=");
                        stringBuilder3.append(this.addQuotesFor(UsageTrackerClient.getPropertyPrivileged(string.trim()), " ", innerQuote));
                        stringBuilder3.append(" ");
                    }
                    this.appendWithQuotes(stringBuilder, stringBuilder3.toString());
                    staticMessage = stringBuilder.toString();
                }
                return staticMessage;
            }
        }

        private void appendWithQuotes(StringBuilder stringBuilder, String string) {
            stringBuilder.append(quote);
            string = string.replace(quote, quote + quote);
            stringBuilder.append(string);
            stringBuilder.append(quote);
        }

        private String addQuotesFor(String string, String string2, String string3) {
            if (string == null) {
                return string;
            }
            if ((string = string.replace(string3, string3 + string3)).indexOf(string2) >= 0) {
                string = string3 + string + string3;
            }
            return string;
        }

        private List<String> getInputArguments() {
            return AccessController.doPrivileged(new PrivilegedAction<List<String>>(){

                @Override
                public List<String> run() {
                    try {
                        Class<?> clazz = Class.forName("java.lang.management.ManagementFactory", true, null);
                        Method method = clazz.getMethod("getRuntimeMXBean", null);
                        Object object = method.invoke(null, null);
                        clazz = Class.forName("java.lang.management.RuntimeMXBean", true, null);
                        method = clazz.getMethod("getInputArguments", null);
                        List list = (List)method.invoke(object, null);
                        return list;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        return Collections.singletonList("n/a");
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw new AssertionError((Object)noSuchMethodException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new AssertionError((Object)illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new AssertionError((Object)invocationTargetException.getCause());
                    }
                }
            });
        }

        private void sendDatagram(String string) {
            UsageTrackerClient.this.printDebug("UsageTracker: sendDatagram");
            try (DatagramSocket datagramSocket = new DatagramSocket();){
                byte[] byArray = string.getBytes("UTF-8");
                if (byArray.length > datagramSocket.getSendBufferSize()) {
                    UsageTrackerClient.this.printVerbose("UsageTracker: message truncated for Datagram.");
                }
                UsageTrackerClient.this.printDebug("UsageTracker: host=" + datagramHost + ", port=" + datagramPort);
                UsageTrackerClient.this.printDebug("UsageTracker: SendBufferSize = " + datagramSocket.getSendBufferSize());
                UsageTrackerClient.this.printDebug("UsageTracker: packet length  = " + byArray.length);
                InetAddress inetAddress = InetAddress.getByName(datagramHost);
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length > datagramSocket.getSendBufferSize() ? datagramSocket.getSendBufferSize() : byArray.length, inetAddress, datagramPort);
                datagramSocket.send(datagramPacket);
                UsageTrackerClient.this.printVerbose("UsageTracker: done sending to UDP.");
                UsageTrackerClient.this.printDebug("UsageTracker: sent size = " + datagramPacket.getLength());
            }
            catch (Throwable throwable) {
                UsageTrackerClient.this.printVerbose("UsageTracker: error in sendDatagram: " + throwable);
                UsageTrackerClient.this.printDebugStackTrace(throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendToFile(String string) {
            UsageTrackerClient.this.printDebug("UsageTracker: sendToFile");
            File file = new File(fullLogFilename);
            if (logFileMaxSize >= 0L && file.length() >= logFileMaxSize) {
                UsageTrackerClient.this.printVerbose("UsageTracker: log file size exceeds maximum.");
                return;
            }
            Object object = LOCK;
            synchronized (object) {
                try (FileOutputStream fileOutputStream = new FileOutputStream(file, true);
                     OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");){
                    outputStreamWriter.write(string, 0, string.length());
                    UsageTrackerClient.this.printVerbose("UsageTracker: done sending to file.");
                    UsageTrackerClient.this.printDebug("UsageTracker: " + fullLogFilename);
                }
                catch (Throwable throwable) {
                    UsageTrackerClient.this.printVerbose("UsageTracker: error in sending to file.");
                    UsageTrackerClient.this.printDebugStackTrace(throwable);
                }
            }
        }

        @Override
        public void run() {
            if (this.runAsync) {
                UsageTrackerClient.this.setupAndTimestamp(this.timestamp);
                UsageTrackerClient.this.printVerbose("UsageTracker: running asynchronous.");
            }
            if (enabled) {
                UsageTrackerClient.this.printDebug("UsageTrackerRunnable.run: " + this.callerName + ", javaCommand: " + this.javaCommand);
                String string = this.buildMessage(this.callerName, this.javaCommand, this.timestamp);
                if (datagramHost != null && datagramPort > 0) {
                    this.sendDatagram(string);
                }
                if (fullLogFilename != null) {
                    this.sendToFile(string);
                }
            }
        }
    }
}

