/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.ka.util;

import com.bmw.gki.ka.util.PreProdHolder;
import com.bmw.gki.ka.util.PreProdLogEntry;
import com.bmw.gki.ka.util.PreProdLogMessages;
import com.bmw.gki.klib.api.exception.KSDAccessException;
import com.bmw.gki.klib.external.cache.KSDCache;
import com.bmw.gki.logging.GKILogManager;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;

public class ExtendedAttributesHandler {
    private static final Log log = GKILogManager.getInstance().getLogger(ExtendedAttributesHandler.class);
    private static final String FILE_NAME = "extendedAttributes.properties";
    private static ExtendedAttributesHandler instance;
    private static String ksdPath;
    private static String preProductionPath;
    private Set<Object> extendedAttributes;

    public static void setKsdPath(String ksd) {
        ksdPath = ksd;
    }

    public static void setPreProductionPath(String preProdPath) {
        preProductionPath = preProdPath;
    }

    public static synchronized ExtendedAttributesHandler getInstance() {
        if (instance == null) {
            instance = new ExtendedAttributesHandler();
        }
        return instance;
    }

    private ExtendedAttributesHandler() {
        this.initialize();
    }

    public boolean isExtendedAttribute(String key) {
        return this.extendedAttributes != null && this.extendedAttributes.contains(key);
    }

    public boolean existExtendedAttributesNameFile() {
        return this.extendedAttributes != null && !this.extendedAttributes.isEmpty();
    }

    public Set<Object> getExtendedAttributesNames() {
        return this.extendedAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        InputStream is = null;
        try {
            URL url = this.getInputURL();
            if (url != null) {
                log.info((Object)(" LOAD EXTENDED Attributes FROM URL: " + url.getPath()));
                is = url.openStream();
                if (is != null) {
                    Properties properties = new Properties();
                    properties.load(is);
                    Set<Object> keySet = properties.keySet();
                    if (keySet != null) {
                        this.extendedAttributes = new TreeSet<Object>(keySet);
                    }
                }
            }
        }
        catch (Exception e) {
            if (PreProdHolder.getIsPreProd()) {
                String message = PreProdLogMessages.getParameterString("CODE_EXT_ATTRIB_NOT_FOUND", null);
                PreProdLogEntry entry = new PreProdLogEntry("INFO", "CODE_EXT_ATTRIB_NOT_FOUND", message);
                PreProdHolder.addLogEntry(entry);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private URL getInputURL() throws KSDAccessException {
        try {
            File file;
            File dir;
            if (KSDCache.getInstance().isPreProduction()) {
                log.trace((Object)("Path to PreProduction is: " + preProductionPath));
                if (preProductionPath == null) {
                    String message = "Definition of extended attributes - preProductionPath not set: " + preProductionPath;
                    KSDAccessException ex = new KSDAccessException(message);
                    log.info((Object)message);
                    throw ex;
                }
                dir = new File(preProductionPath);
                if (!dir.exists()) {
                    String message = "Definition of extended attributes - invalid preProductionPath: " + preProductionPath;
                    KSDAccessException ex = new KSDAccessException(message);
                    log.info((Object)message);
                    throw ex;
                }
                file = new File(dir, FILE_NAME);
                if (file.exists()) {
                    return file.toURI().toURL();
                }
            }
            log.trace((Object)("Path to KSD is: " + ksdPath));
            if (ksdPath == null) {
                String message = "Definition of extended attributes - ksdPath not set: " + ksdPath;
                KSDAccessException ex = new KSDAccessException(message);
                log.info((Object)message);
                throw ex;
            }
            dir = new File(ksdPath);
            if (!dir.exists()) {
                String message = "Definition of extended attributes - invalid ksdPath: " + ksdPath;
                KSDAccessException ex = new KSDAccessException(message);
                log.info((Object)message);
                throw ex;
            }
            file = new File(dir, FILE_NAME);
            if (file.exists()) {
                return file.toURI().toURL();
            }
            return this.getClass().getClassLoader().getResource(FILE_NAME);
        }
        catch (MalformedURLException e) {
            String message = "Definition of extended attributes MalformedURLException, ksdPath: " + ksdPath + ", preProductionPath: " + preProductionPath;
            KSDAccessException ex = new KSDAccessException(message, e);
            log.info((Object)message);
            throw ex;
        }
    }

    public static void reset() {
        instance = null;
    }
}

