/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.ka.util.resource;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class ResourcesChecker {
    private static File[] JAVA_DIRS = new File[]{new File("D:\\Projects\\GKI\\workspace\\gki\\src")};

    public static void main(String[] args) throws Exception {
        HashSet<File> javaFiles = new HashSet<File>();
        for (int i = 0; i < JAVA_DIRS.length; ++i) {
            File javaDir = JAVA_DIRS[i];
            javaFiles.addAll(ResourcesChecker.getAllJavaFiles(javaDir));
        }
        File resourceDir = new File("D:\\Projects\\GKI\\workspace\\gki\\resource");
        ArrayList<String> resources = new ArrayList<String>();
        resources.add("gki_translator");
        resources.add("ExceptionMessages");
        for (String resource : resources) {
            ResourcesChecker.handleResource(resourceDir, resource, javaFiles);
        }
    }

    private static List<File> getAllJavaFiles(File dir) {
        ArrayList<File> result = new ArrayList<File>();
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                result.addAll(ResourcesChecker.getAllJavaFiles(file));
                continue;
            }
            if (!file.getName().toLowerCase().endsWith(".java")) continue;
            result.add(file);
        }
        return result;
    }

    private static void handleResource(File resourceDir, String bundleName, Set<File> javaFiles) throws Exception {
        List<SortedProperties> resourceFiles = ResourcesChecker.getAllResourceFiles(resourceDir, bundleName);
        ArrayList<Object> keys = new ArrayList<Object>(ResourcesChecker.getAllResourceKeys(resourceFiles));
        Collections.sort(keys, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return String.valueOf(o1).toLowerCase().compareTo(String.valueOf(o2).toLowerCase());
            }
        });
        for (File javaFile : javaFiles) {
            String content = ResourcesChecker.getFileContent(javaFile);
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                boolean found = ResourcesChecker.searchInContent(key, content);
                if (!found) continue;
                iterator.remove();
                System.out.println("--> key '" + key + "' found in file " + javaFile);
            }
        }
        for (SortedProperties resourceFile : resourceFiles) {
            for (String string : keys) {
                Object removed = resourceFile.remove(string);
                if (removed == null) continue;
                System.out.println("key '" + string + "' removed from file " + resourceFile.getFile());
            }
            resourceFile.save();
        }
    }

    private static Set<Object> getAllResourceKeys(List<SortedProperties> resourceFiles) {
        HashSet<Object> keys = new HashSet<Object>();
        for (SortedProperties resourceFile : resourceFiles) {
            keys.addAll(resourceFile.keySet());
        }
        return keys;
    }

    private static String getKeyPrefix(String key) {
        int p = key.lastIndexOf(".");
        if (p > 0) {
            return key.substring(0, p);
        }
        return null;
    }

    private static boolean searchInContent(String key, String content) {
        if (content.indexOf("\"" + key + "\"") >= 0) {
            return true;
        }
        String keyPrefix = ResourcesChecker.getKeyPrefix(key);
        if (keyPrefix != null && content.indexOf("\"" + keyPrefix + ".\"") >= 0) {
            System.out.println("-------------------------- key '" + key + "' found with prefix '" + keyPrefix + "'");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFileContent(File file) throws IOException {
        StringBuffer sb = new StringBuffer();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = in.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            in.close();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return sb.toString();
    }

    private static List<SortedProperties> getAllResourceFiles(File resourceDir, String bundleName) throws Exception {
        File[] files = resourceDir.listFiles(new ResourceFileNameFilter(bundleName));
        ArrayList<SortedProperties> resourceFiles = new ArrayList<SortedProperties>();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            SortedProperties resourceFile = new SortedProperties(file);
            resourceFile.load();
            resourceFiles.add(resourceFile);
        }
        return resourceFiles;
    }

    public static class ResourceFileNameFilter
    implements FilenameFilter {
        private String bundleName;

        public ResourceFileNameFilter(String bundleName) {
            this.bundleName = bundleName;
        }

        @Override
        public boolean accept(File dir, String name) {
            String regex = "^(" + this.bundleName + ")" + "((_[a-z]{2})|(_[a-z]{2}_[A-Z]{2})" + "|(_[a-z]{2}_[A-Z]{2}_\\w*))?(\\.properties" + ")$";
            return name.matches(regex);
        }
    }

    public static class SortedProperties
    extends Properties {
        private static final long serialVersionUID = 1L;
        private File file;

        public SortedProperties(File file) {
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void load() throws IOException {
            FileInputStream in = null;
            try {
                in = new FileInputStream(this.file);
                this.load(in);
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void save() throws Exception {
            OutputStream out = null;
            try {
                if (!this.file.getParentFile().exists()) {
                    this.file.getParentFile().mkdirs();
                }
                out = new FileOutputStream(this.file);
                this.store(out, "changed by " + ResourcesChecker.class.getName());
                out.flush();
                out.close();
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        public File getFile() {
            return this.file;
        }

        public synchronized List<String> sortedKeys() {
            ArrayList<String> keys = new ArrayList<String>();
            for (String string : this.keySet()) {
                if (keys.contains(string)) continue;
                keys.add(string);
            }
            Collections.sort(keys, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return String.valueOf(o1).toLowerCase().compareTo(String.valueOf(o2).toLowerCase());
                }
            });
            return keys;
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            final Iterator<String> it = this.sortedKeys().iterator();
            return new Enumeration<Object>(){

                @Override
                public boolean hasMoreElements() {
                    return it.hasNext();
                }

                @Override
                public Object nextElement() {
                    return it.next();
                }
            };
        }
    }
}

