/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.api;

import com.bmw.gki.ka.exception.Messages;
import com.bmw.gki.ka.exception.PreProductionAccessException;
import com.bmw.gki.klib.api.exception.JarLoadException;
import com.bmw.gki.klib.api.exception.KSDAccessException;
import com.bmw.gki.klib.api.exception.KSDVersionException;
import com.bmw.gki.klib.config.GKISettings;
import com.bmw.gki.klib.external.cache.KSDCache;
import com.bmw.gki.logging.GKILogManager;
import com.bmw.gki.logging.LogManagerIF;
import java.io.FileNotFoundException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.sql.DataSource;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.CalendarConverter;
import org.apache.commons.logging.Log;

public class AdminInterface {
    private static Log log = GKILogManager.getInstance().getLogger(AdminInterface.class);

    public static void setKSDPath(String path, boolean withJarUpdate) throws KSDVersionException, KSDAccessException, JarLoadException {
        AdminInterface.setKSDPath(path, withJarUpdate, new GKISettings(), true);
    }

    public static void setKSDPath(String path, boolean withJarUpdate, GKISettings settings, boolean checkKSDVersion) throws KSDVersionException, KSDAccessException, JarLoadException {
        log.debug((Object)("setksdpath, path:" + path + ", withJarUpdate:" + withJarUpdate));
        KSDCache.reset();
        KSDCache.getInstance().setKSD(path, withJarUpdate, settings, checkKSDVersion);
    }

    public static void setKeyAnalyserLibPath(String path) throws FileNotFoundException, JarLoadException {
        log.debug((Object)("updating keyanalyser, path:" + path));
        KSDCache.reset();
        KSDCache.getInstance().updateKeyAnalyser(path);
    }

    public static void setPreProductionPath(String path) throws PreProductionAccessException {
        log.debug((Object)("set pre-production path, path:" + path));
        KSDCache.getInstance().setPreProduction(path);
    }

    public static String getLocalizedErrorMessage(String resourceKey, Locale locale) throws MissingResourceException {
        String message = Messages.getInstance().getString(resourceKey, locale);
        message = AdminInterface.filterPlaceholders(message);
        return message;
    }

    public static void setDataSource(DataSource ds) throws SQLException {
        KSDCache.getInstance().setKSDDataSource(ds);
    }

    public static void setLogManager(LogManagerIF logManager) {
        GKILogManager.setInstance(logManager);
    }

    private static String filterPlaceholders(String message) {
        if (message != null) {
            message = message.replaceAll("\\{(\\d)+\\}( )?", "");
        }
        return message;
    }

    static {
        Locale.setDefault(new Locale("en", "GB"));
        CalendarConverter converter = new CalendarConverter(null);
        ConvertUtils.register((Converter)converter, Calendar.class);
    }
}

