/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.api;

import com.bmw.gki.klib.api.Fahreigenschaft;
import com.bmw.gki.klib.data.ksd.cbs.BOSNummer;
import java.util.Hashtable;

public class BSIBerechnungsbasis {
    private int max;
    private float wenigfahrerZeitFaktor;
    private float vielFahrerZeitFaktor;
    private float wenigfahrerLaufleistungsFaktor;
    private float vielfahrerLaufleistungsFaktor;
    private int min;
    private Hashtable<?, ?> bsiVorziehbereich;

    public BSIBerechnungsbasis(int max, int min, float wenigfahrerZeitFaktor, float vielFahrerZeitFaktor, float wenigfahrerLaufleistungsFaktor, float vielfahrerLaufleistungsFaktor) {
        this.max = max;
        this.min = min;
        this.wenigfahrerZeitFaktor = wenigfahrerZeitFaktor;
        this.vielFahrerZeitFaktor = vielFahrerZeitFaktor;
        this.wenigfahrerLaufleistungsFaktor = wenigfahrerLaufleistungsFaktor;
        this.vielfahrerLaufleistungsFaktor = vielfahrerLaufleistungsFaktor;
    }

    public void setBSIVorziehbereich(Hashtable<?, ?> bsiVorziehbereiche) {
        this.bsiVorziehbereich = bsiVorziehbereiche;
    }

    public Hashtable<?, ?> getBSIVorziehbereich() {
        return this.bsiVorziehbereich;
    }

    public float ermittleFaktor(Fahreigenschaft fahreigenschaft, int typ) {
        if (fahreigenschaft.isNormalfahrer()) {
            return 1.0f;
        }
        if (fahreigenschaft.isVielfahrer()) {
            if (typ == 1) {
                return this.vielfahrerLaufleistungsFaktor;
            }
            if (typ == 2) {
                return this.vielFahrerZeitFaktor;
            }
        }
        if (fahreigenschaft.isWenigfahrer()) {
            if (typ == 1) {
                return this.wenigfahrerLaufleistungsFaktor;
            }
            if (typ == 2) {
                return this.wenigfahrerZeitFaktor;
            }
        }
        return 1.0f;
    }

    public int getMin() {
        return this.min;
    }

    public float getVielfahrerLaufleistungsFaktor() {
        return this.vielfahrerLaufleistungsFaktor;
    }

    public float getVielFahrerZeitFaktor() {
        return this.vielFahrerZeitFaktor;
    }

    public float getWenigfahrerLaufleistungsFaktor() {
        return this.wenigfahrerLaufleistungsFaktor;
    }

    public float getWenigfahrerZeitFaktor() {
        return this.wenigfahrerZeitFaktor;
    }

    public int getMax() {
        return this.max;
    }

    public boolean hasBsiVorziehbereich(BOSNummer cbsnr) {
        if (this.getBSIVorziehbereich() == null) {
            return false;
        }
        return this.getBSIVorziehbereich().containsKey(cbsnr.getIdString());
    }
}

