/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.api;

import com.bmw.gki.klib.api.exception.KSDPropertyFormatException;
import com.bmw.gki.klib.api.exception.SettingsException;
import com.bmw.gki.klib.common.Einstellungen;
import com.bmw.gki.klib.config.GKICache;
import com.bmw.gki.klib.config.GKICacheObject;
import com.bmw.gki.klib.external.cache.BOSNummerReader;
import com.bmw.gki.klib.external.cache.BOSVerknuepfungReader;
import java.io.File;

public class GKIDataPaketOptimizer {
    public static void main(String[] args) {
        String dataPaketPath;
        File dir;
        boolean params = true;
        if (args == null) {
            params = false;
        }
        if (params && args.length == 0) {
            System.out.println("Usage: GKICacheGenerator <Pfad zum Datenpaket>");
            System.exit(-1);
        }
        if (!(dir = new File((dataPaketPath = args[0] + "/SAM") + "/GKI")).exists()) {
            System.out.println("GKICacheGenerator: Pfad zu " + dataPaketPath + "/SAM/GKI nicht korrekt!");
            System.exit(-1);
        }
        GKICacheObject bosCacheObject = new GKICacheObject("CACHE_BOSVALUECACHE");
        bosCacheObject.setCacheActivated(true);
        bosCacheObject.setShouldWrite(true);
        bosCacheObject.setFileDirectory(dataPaketPath + "/GKI");
        bosCacheObject.setFileName("boscache");
        GKICache gkiCache = new GKICache();
        gkiCache.addCacheObject("CACHE_BOSVALUECACHE", bosCacheObject);
        String[] regionCodes = new String[]{"ECE", "SSI", "USA", "JP"};
        dataPaketPath = dataPaketPath + "/Data1";
        System.out.println("Generiere Daten...");
        try {
            BOSNummerReader.einlesenTabelle(dataPaketPath, Einstellungen.getSupportedLocales());
        }
        catch (KSDPropertyFormatException | SettingsException e1) {
            e1.printStackTrace();
        }
        try {
            BOSVerknuepfungReader.einlesenTabelle(dataPaketPath, regionCodes, gkiCache);
        }
        catch (KSDPropertyFormatException | SettingsException e) {
            e.printStackTrace();
        }
    }
}

