/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.config;

import com.bmw.gki.klib.api.GKISettingsRessource;
import com.bmw.gki.klib.api.exception.LocaleHolder;
import com.bmw.gki.klib.common.Einstellungen;
import com.bmw.gki.klib.common.LanguageSelection;
import com.bmw.gki.klib.external.cache.RegionReader;
import com.bmw.gki.klib.util.GKIHelper;
import java.util.Locale;

public class GKISettings {
    private Locale locale;
    private boolean isMiles;
    private boolean isFahrenheit;
    private boolean isGallonsUK;
    private boolean isGallonsUS;

    public GKISettings(Locale locale, boolean isMiles) {
        this.locale = LanguageSelection.getInstance().getValidLocale(locale);
        this.isMiles = isMiles;
        this.isFahrenheit = false;
        this.isGallonsUK = false;
        this.isGallonsUS = false;
        LocaleHolder.setLocale(locale);
    }

    public GKISettings(String localeString, boolean isMiles, boolean isFahrenheit, boolean isGallonsUS, boolean isGallonsUK) {
        this.locale = LanguageSelection.getInstance().getValidLocale(GKIHelper.createLocale(localeString));
        this.isMiles = isMiles;
        this.isFahrenheit = isFahrenheit;
        this.isGallonsUK = isGallonsUK;
        this.isGallonsUS = isGallonsUS;
        LocaleHolder.setLocale(this.locale);
    }

    public GKISettings() {
        this(Einstellungen.getDefaultInstance().getLanguage(), Einstellungen.isMilesSet());
    }

    public GKISettings(String localeString, boolean isMiles) {
        this(GKIHelper.createLocale(localeString), isMiles);
    }

    public String getDisplayDistance() {
        return GKISettingsRessource.getString("displaydistance");
    }

    public String getRegionCode() {
        return RegionReader.find(this.locale);
    }

    public boolean isMiles() {
        return this.isMiles;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean isFahrenheit() {
        return this.isFahrenheit;
    }

    public boolean isGallonsUK() {
        return this.isGallonsUK;
    }

    public boolean isGallonsUS() {
        return this.isGallonsUS;
    }
}

