/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.apiparams;

import com.bmw.gki.ka.keydata.FieldRecordTo;
import com.bmw.gki.klib.api.exception.WriteOperationNotSupportedException;
import com.bmw.gki.klib.api_current.KeyDataAnalysedType;
import com.bmw.gki.klib.api_current.impl.KeyDataAnalysedTypeImpl;
import com.bmw.gki.klib.data.apiparams.KeyDataHelper;
import com.bmw.gki.klib.data.apiparams.Led;
import com.bmw.gki.klib.data.apiparams.SIAData;
import com.bmw.gki.logging.GKILogManager;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;

public class SIABaseData
implements KeyDataAnalysedType.SiaData {
    private FieldRecordTo fieldRecord;
    private static Log log = GKILogManager.getInstance().getLogger(SIABaseData.class);

    public SIABaseData(FieldRecordTo fieldRecord) {
        this.fieldRecord = fieldRecord;
        if (fieldRecord != null) {
            log.debug((Object)("init SiaBaseData with record id: " + fieldRecord.getId()));
        }
    }

    @Override
    public KeyDataAnalysedType.SiaData.Sia getSia() {
        SIAData siaSrcType = new SIAData(this.fieldRecord);
        if (siaSrcType.isSetCodedTimeIntervall() || siaSrcType.isSetSiaDue() || siaSrcType.isSetSiaVersion() || siaSrcType.isSetSiTimeInspectionCounter()) {
            return (KeyDataAnalysedType.SiaData.Sia)KeyDataHelper.copyValues(new KeyDataAnalysedTypeImpl.SiaDataImpl.SiaImpl(), siaSrcType);
        }
        return null;
    }

    @Override
    public void setSia(KeyDataAnalysedType.SiaData.Sia value) {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public KeyDataAnalysedType.SiaData.Led getLed() {
        Led srcLed = new Led(this.fieldRecord);
        KeyDataAnalysedTypeImpl.SiaDataImpl.LedImpl destLed = null;
        if (srcLed != null) {
            destLed = new KeyDataAnalysedTypeImpl.SiaDataImpl.LedImpl();
            destLed.setLedRed(srcLed.isLedRed());
            destLed.setLedYellow(srcLed.isLedYellow());
            List<Boolean> greenLed = srcLed.getLedGreen();
            if (greenLed != null) {
                Iterator<Boolean> iter = greenLed.iterator();
                while (iter.hasNext()) {
                    destLed.getLedGreen().add(iter.next());
                }
            }
        }
        return destLed;
    }

    @Override
    public void setLed(KeyDataAnalysedType.SiaData.Led value) {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public Double getSiaRemainingDistance() {
        return KeyDataHelper.getDoubleFromFieldRecordTo(this.fieldRecord, "restweg");
    }

    @Override
    public void setSiaRemainingDistance(Double value) {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public boolean isSetSia() {
        return this.getSia() != null;
    }

    public void unsetSia() {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public boolean isSetLed() {
        return this.getLed() != null;
    }

    public void unsetLed() {
        throw new WriteOperationNotSupportedException();
    }

    @Override
    public boolean isSetSiaRemainingDistance() {
        return KeyDataHelper.getIsSetFromFieldRecordTo(this.fieldRecord, "restweg");
    }

    public void unsetSiaRemainingDistance() {
        throw new WriteOperationNotSupportedException();
    }
}

