/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.ksd.bsi;

import com.bmw.gki.ka.exception.GKIException;
import com.bmw.gki.klib.api.BSIBerechnungsbasis;
import com.bmw.gki.klib.api_current.ServicePackageType;
import com.bmw.gki.klib.api_current.impl.DescriptionTypeImpl;
import com.bmw.gki.klib.api_current.impl.ServicePackageEvalTypeImpl;
import com.bmw.gki.klib.api_current.impl.TypeUnitValueImpl;
import com.bmw.gki.klib.config.GKISettings;
import com.bmw.gki.klib.data.apiparams.KeyDataHelper;
import com.bmw.gki.klib.data.ksd.bsi.BSIDatensatzfehlerhaftException;
import com.bmw.gki.klib.data.xsd.Mileage;
import com.bmw.gki.klib.util.GKIHelper;
import com.bmw.gki.klib.util.Utilities;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;

public class BSIServicePaket {
    private static final String CONTRACT_DATA_CORRUPT_STRING = "contract data corrupt";
    private static final String ACTIVE_CONTRACT_WITHOUT_CALCULATION_BASE_STRING = "active contract without calculation base";
    private static final String START_DATE_MISSING_STRING = "start date missing";
    private static final String DURATION_END_DATE_EXCEEDED_STRING = "duration/end date exceeded";
    private static final String END_DATE_EXCEEDED_STRING = "end date exceeded";
    private static final String DURATION_EXCEEDED_STRING = "duration exceeded";
    private static final String ACTIVE_STRING = "active";
    private static final String[] PACKAGE_STATE_MAP = new String[]{"active", "duration exceeded", "end date exceeded", "duration/end date exceeded", "start date missing", "active contract without calculation base", "contract data corrupt"};
    private String origin;
    private String contractVolume;
    public static final Integer AKTIV = new Integer(0);
    public static final Integer LAUFLEISTUNGUEBERSCHRITTEN = new Integer(1);
    public static final Integer LAUFZEITUEBERSCHRITTEN = new Integer(2);
    public static final Integer ZEITKMUEBERSCHRITTEN = new Integer(3);
    public static final Integer VERTRAGSDATEN_ERSTZULASSUNG_FEHLERHAFT = new Integer(4);
    public static final Integer KEINE_FAELLIGKEITSDATEN = new Integer(5);
    public static final Integer VERTRAGSDATEN_FEHLERHAFT = new Integer(6);
    public static Date defaultBSIDatum = new Date(70, 0, 1);
    private Integer status;
    private Integer dauer;
    private String contractType;
    private Date startDatum;
    private Integer distanzKM;
    private String kurzBeschreibung;
    private Date endeDatum;
    private Date cashUpStartDate;
    private long startKm;
    private long endKm;
    private String saOptionCode;
    private boolean supportSystemSACode;
    private BSIBerechnungsbasis lnkBSIBerechnungsbasis;

    public BSIServicePaket(String contractType, Integer dauer, Integer distanzKM, Date startDatum, Date endeDatum, String kurzBeschreibung, String origin, String contractVolume) {
        this.contractType = contractType;
        this.dauer = dauer;
        this.distanzKM = distanzKM;
        this.startDatum = startDatum;
        this.endeDatum = endeDatum;
        this.kurzBeschreibung = kurzBeschreibung;
        this.origin = origin;
        this.contractVolume = contractVolume;
    }

    public Integer getStatus() {
        return this.status;
    }

    public boolean isAktiv() {
        return this.status.equals(AKTIV);
    }

    private boolean pruefeLaufleistung(int fzgKM) throws BSIDatensatzfehlerhaftException {
        return this.startKm <= (long)fzgKM && (long)fzgKM <= this.endKm;
    }

    public Integer pruefeGueltigkeit(int fzgKM, Date einlesedatum, Date zulassungsdatum) throws BSIDatensatzfehlerhaftException {
        if (this.getBerechnungsbasis() == null) {
            this.status = KEINE_FAELLIGKEITSDATEN;
            return this.status;
        }
        if (this.cashUpStartDate == null || this.endeDatum == null || this.getEndKM() == null || this.getStartKM() == null) {
            this.status = VERTRAGSDATEN_FEHLERHAFT;
            return this.status;
        }
        if (einlesedatum.before(this.endeDatum) && einlesedatum.after(this.cashUpStartDate)) {
            this.status = this.pruefeLaufleistung(fzgKM) ? AKTIV : LAUFLEISTUNGUEBERSCHRITTEN;
        } else {
            this.status = LAUFZEITUEBERSCHRITTEN;
            if (!this.pruefeLaufleistung(fzgKM)) {
                this.status = ZEITKMUEBERSCHRITTEN;
            }
        }
        return this.status;
    }

    public long getDistanz(boolean isMilesSet) {
        if (isMilesSet) {
            return Math.round(Utilities.convertToMiles(this.distanzKM.intValue()));
        }
        return this.distanzKM.intValue();
    }

    public BSIBerechnungsbasis getBerechnungsbasis() {
        return this.lnkBSIBerechnungsbasis;
    }

    public void setBerechnungsbasis(BSIBerechnungsbasis berechnungsbasis) {
        this.lnkBSIBerechnungsbasis = berechnungsbasis;
    }

    public Integer getDauer() {
        return this.dauer;
    }

    public String getKurzBeschreibung() {
        return this.kurzBeschreibung;
    }

    public Date getStartDatum() {
        return this.startDatum;
    }

    public String getVertragsTyp() {
        return this.contractType;
    }

    public Integer getDistanzKM() {
        return this.distanzKM;
    }

    public Date getEndeDatum() {
        return this.endeDatum;
    }

    public long getStartKM(boolean isMilesSet) {
        int start;
        Integer startKM = this.getStartKM();
        int n = start = startKM != null ? startKM : 0;
        if (isMilesSet) {
            return Math.round(Utilities.convertToMiles(start));
        }
        return start;
    }

    private Integer getStartKM() {
        return new Integer((int)this.startKm);
    }

    public long getEndKM(boolean isMilesSet) {
        int end;
        Integer endKM = this.getEndKM();
        int n = end = endKM != null ? endKM : 0;
        if (isMilesSet) {
            return Math.round(Utilities.convertToMiles(end));
        }
        return end;
    }

    private Integer getEndKM() {
        return new Integer((int)this.endKm);
    }

    public Date getCashUpStartDate() {
        return this.cashUpStartDate;
    }

    public String toString() {
        DateFormat df = DateFormat.getInstance();
        StringBuffer sb = new StringBuffer();
        if (this.getVertragsTyp() != null) {
            sb.append(" try: ");
            sb.append(this.getVertragsTyp());
        }
        if (this.getStatus() != null) {
            sb.append(" status: ");
            sb.append(this.getStatus());
        }
        if (this.getKurzBeschreibung() != null) {
            sb.append(" description: ");
            sb.append(this.getKurzBeschreibung());
        }
        if (this.getDauer() != null) {
            sb.append(" duration: ");
            sb.append(this.getDauer());
        }
        sb.append(" distance (km): ");
        sb.append(this.getDistanz(false));
        if (this.getStartDatum() != null) {
            sb.append(" start date: ");
            sb.append(df.format(this.getStartDatum()));
        }
        if (this.getEndeDatum() != null) {
            sb.append(" end date: ");
            sb.append(df.format(this.getEndeDatum()));
        }
        sb.append(" startKm (km): ");
        sb.append(this.getStartKM(false));
        sb.append(" endKm (km): ");
        sb.append(this.getEndKM(false));
        if (this.getCashUpStartDate() != null) {
            sb.append(" cash up start date: ");
            sb.append(df.format(this.getCashUpStartDate()));
        }
        return sb.toString();
    }

    public ServicePackageType createServicePackageType(GKISettings settings, TimeZone timeZone) throws GKIException {
        ServicePackageEvalTypeImpl packageType = new ServicePackageEvalTypeImpl();
        packageType.setContract(this.getVertragsTyp());
        if (this.getEndeDatum() != null) {
            packageType.setEndDate(KeyDataHelper.retrieveXMLGregorianCalendar(this.getEndeDatum(), timeZone));
        } else {
            packageType.setEndDate(null);
        }
        if (this.getStartDatum() != null) {
            packageType.setStartDate(KeyDataHelper.retrieveXMLGregorianCalendar(this.getStartDatum(), timeZone));
        } else {
            packageType.setStartDate(null);
        }
        if (this.getKurzBeschreibung() != null) {
            DescriptionTypeImpl descr = new DescriptionTypeImpl();
            StringBuffer language = new StringBuffer(settings.getLocale().getLanguage());
            if (settings.getLocale().getCountry() != null) {
                language.append("-").append(settings.getLocale().getCountry());
            }
            descr.setLanguage(language.toString());
            descr.setValue(this.getKurzBeschreibung());
            packageType.setDescription(descr);
        }
        packageType.setDistance(new Mileage(new Long(this.getDistanz(settings.isMiles())).toString(), settings.isMiles() ? "miles" : "km").createMileageType(settings.getLocale()));
        if (this.getCashUpStartDate() != null) {
            packageType.setCashUpStartDate(KeyDataHelper.retrieveXMLGregorianCalendar(this.getCashUpStartDate(), timeZone));
        } else {
            packageType.setCashUpStartDate(null);
        }
        packageType.setStartKm(new Mileage(new Long(this.getStartKM(settings.isMiles())).toString(), settings.isMiles() ? "miles" : "km").createMileageType(settings.getLocale()));
        packageType.setEndKm(new Mileage(new Long(this.getEndKM(settings.isMiles())).toString(), settings.isMiles() ? "miles" : "km").createMileageType(settings.getLocale()));
        if (this.getDauer() != null) {
            TypeUnitValueImpl value = new TypeUnitValueImpl();
            value.setUnits("month");
            value.setValueInDisplayFormat(this.getDauer().toString());
            long wert = this.getDauer().longValue();
            String unitDisplay = wert == 1L ? GKIHelper.getTableString("auftragsbasisDialog.auftragsbasisTable.restlaufColumn.monat", settings.getLocale()) : GKIHelper.getTableString("auftragsbasisDialog.auftragsbasisTable.restlaufColumn.monate", settings.getLocale());
            value.setUnitsInDisplayFormat(unitDisplay);
            value.setValue(BigDecimal.valueOf(wert));
            packageType.setDuration(value);
        }
        packageType.setContractVolume(this.getContractVolume());
        packageType.setOrigin(this.getOrigin());
        if (this.getStatus() != null && this.getStatus() <= 6) {
            packageType.setState(PACKAGE_STATE_MAP[this.getStatus()]);
        }
        return packageType;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getContractVolume() {
        return this.contractVolume;
    }

    public void setCashUpStartDate(Date cashUpStartDate) {
        this.cashUpStartDate = cashUpStartDate;
    }

    public void setEndKm(long endKm) {
        this.endKm = endKm;
    }

    public void setStartKm(long startKm) {
        this.startKm = startKm;
    }

    public String getSAOptionCode() {
        return this.saOptionCode;
    }

    public void setSAOptionCode(String saOptionCode) {
        this.saOptionCode = saOptionCode;
    }

    public void setSupportSystemSACode(boolean supportSystemSACode) {
        this.supportSystemSACode = supportSystemSACode;
    }

    public boolean getSupportSystemSACode() {
        return this.supportSystemSACode;
    }
}

