/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.ksd.bsi;

import com.bmw.gki.klib.data.ksd.bsi.BSIDatensatzfehlerhaftException;

public class BSIVorziehbereich {
    private static final int ZEIT = 1;
    private static final int WEG = 2;
    private static final int KOMBI = 3;
    private static final int UNDEF = 0;
    private int status = 0;
    private Integer vorziehbereichZeit;
    private Integer vorziehbereichStrecke;

    public int ermittleWert(int typ) throws BSIDatensatzfehlerhaftException {
        switch (typ) {
            case 1: {
                return this.getVorziehbereichStrecke();
            }
            case 2: {
                return this.getVorziehbereichZeit();
            }
            case 65535: {
                if (this.vorziehbereichStrecke != null) {
                    return this.getVorziehbereichStrecke();
                }
                if (this.vorziehbereichZeit == null) break;
                return this.getVorziehbereichZeit();
            }
        }
        String message = "CBS Position 'KM' and 'ZEIT' is null - BISVohrziehbereich (ermittleWert)";
        BSIDatensatzfehlerhaftException ex = new BSIDatensatzfehlerhaftException(message);
        throw ex;
    }

    public BSIVorziehbereich(Integer zeit, Integer strecke, int kennung) {
        if (this.isSet(zeit) && this.isSet(strecke)) {
            this.status = 3;
        } else {
            if (this.isSet(zeit)) {
                this.status = 1;
            }
            if (this.isSet(strecke)) {
                this.status = 2;
            }
        }
        this.vorziehbereichStrecke = strecke;
        this.vorziehbereichZeit = zeit;
    }

    private boolean isSet(Integer obj) {
        return obj != null && obj > 0;
    }

    public boolean isCombined() {
        return 3 == this.status;
    }

    public boolean isZeit() {
        return 1 == this.status;
    }

    public boolean isWeg() {
        return 2 == this.status;
    }

    public int getVorziehbereichZeit() throws BSIDatensatzfehlerhaftException {
        if ((this.status == 1 || this.status == 3) && this.isSet(this.vorziehbereichZeit)) {
            return this.vorziehbereichZeit;
        }
        String message = "(status != ZEIT && status != KOMBI) || vorziehbereichZeit is not set - BISVorziehbereich (getVorziehbereichStrecke)";
        BSIDatensatzfehlerhaftException ex = new BSIDatensatzfehlerhaftException(message);
        throw ex;
    }

    public int getVorziehbereichStrecke() throws BSIDatensatzfehlerhaftException {
        if ((this.status == 2 || this.status == 3) && this.isSet(this.vorziehbereichStrecke)) {
            return this.vorziehbereichStrecke;
        }
        String message = "(status != WEG && status != KOMBI) || vorziehbereichStrecke is not set  - BISVorziehbereich (getVorziehbereichStrecke)";
        BSIDatensatzfehlerhaftException ex = new BSIDatensatzfehlerhaftException(message);
        throw ex;
    }
}

