/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.ksd.cbs;

import com.bmw.gki.klib.data.ksd.cbs.BOSNummer;
import java.io.Serializable;

public class BOSAWNummer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String leittyp;
    private BOSNummer bosNr;
    private int baustandAnfang;
    private int baustandEnde;
    private String awNrHaupt;
    private String awNrVerbund;
    private String awWertHaupt;
    private String awWertVerbund;
    private String ssiAwNummerHaupt;
    private String ssiAwWertHaupt;
    private String ssiAwNummerVerbund;
    private String ssiAwWertVerbund;

    public BOSAWNummer(String leittyp, BOSNummer bosNr, int baustandAnfang, int baustandEnde, String awNrHaupt, String awWertHaupt, String awNrVerbund, String awWertVerbund, String ssiAwNummerHaupt, String ssiAwWertHaupt, String ssiAwNummerVerbund, String ssiAwWertVerbund) {
        this.leittyp = leittyp;
        this.bosNr = bosNr;
        this.baustandAnfang = baustandAnfang;
        this.baustandEnde = baustandEnde;
        this.awNrHaupt = awNrHaupt;
        this.awWertHaupt = awWertHaupt;
        this.awNrVerbund = awNrVerbund;
        this.awWertVerbund = awWertVerbund;
        this.ssiAwNummerHaupt = ssiAwNummerHaupt;
        this.ssiAwWertHaupt = ssiAwWertHaupt;
        this.ssiAwNummerVerbund = ssiAwNummerVerbund;
        this.ssiAwWertVerbund = ssiAwWertVerbund;
    }

    public String getLeittyp() {
        return this.leittyp;
    }

    public BOSNummer getBosNr() {
        return this.bosNr;
    }

    public String getAwNrHaupt() {
        return this.awNrHaupt;
    }

    public String getAwNrVerbund() {
        return this.awNrVerbund;
    }

    public String getAwWertHaupt() {
        return this.awWertHaupt;
    }

    public String getAwWertVerbund() {
        return this.awWertVerbund;
    }

    public String getSsiAwNrHaupt() {
        return this.ssiAwNummerHaupt;
    }

    public String getSsiAwNrVerbund() {
        return this.ssiAwNummerVerbund;
    }

    public String getSsiAwWertHaupt() {
        return this.ssiAwWertHaupt;
    }

    public String getSsiAwWertVerbund() {
        return this.ssiAwWertVerbund;
    }

    public int getBaustandAnfang() {
        return this.baustandAnfang;
    }

    public int getBaustandEnde() {
        return this.baustandEnde;
    }

    public boolean isValid(String leittypValue, BOSNummer bosNummer, int baustand) {
        String testLeit = this.getLeittyp().trim();
        BOSNummer testNum = this.getBosNr();
        if (!testLeit.equals(leittypValue)) {
            return false;
        }
        if (testNum.getBosNr() != bosNummer.getBosNr()) {
            return false;
        }
        return this.isValidBaustand(baustand);
    }

    public boolean isValidBaustand(int baustand) {
        int testBauAnf = this.getBaustandAnfang();
        int testBauEnd = this.getBaustandEnde();
        return !(testBauEnd == 0 ? testBauAnf > baustand : testBauAnf > baustand || testBauEnd <= baustand);
    }

    public String toString() {
        String retval = this.getLeittyp() + "\t" + this.getBosNr() + "\t" + this.getBaustandAnfang() + "\t" + this.getBaustandEnde() + "\t" + this.getAwNrHaupt() + "\t" + this.getAwWertHaupt() + "\t" + this.getAwNrVerbund() + "\t" + this.getAwWertVerbund();
        return retval;
    }
}

