/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.ksd.cbs;

import com.bmw.gki.klib.data.ksd.cbs.BOSNummer;
import java.io.Serializable;

public class BOSVerknuepfung
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int SICHTBARKEIT_KONSTANT = 1;
    public static final int SICHTBARKEIT_DYNAMISCH = 0;
    public static final String SICHTBARKEIT_KONSTANT_S = "1";
    public static final String SICHTBARKEIT_DYNAMISCH_S = "0";
    private String leittyp;
    private int baustandAnfang;
    private int baustandEnde;
    private int wiederholungswert;
    public static final String ASC = "ASC";
    public static final String PSC = "PSC";
    public static final String APD = "APD";
    private String typ;
    private int faelligAb;
    private int faelligBis;
    private String einheit;
    private int sichtbarkeit;
    private BOSNummer bosNrVon;
    private BOSNummer bosNrNach;
    private String fileName = "_con1.properties";

    public BOSVerknuepfung(String leittyp, int baustandAnfang, int baustandEnde, String typ, int faelligAb, int faelligBis, String einheit, BOSNummer bosNrVon, BOSNummer bosNrNach) {
        this.leittyp = leittyp;
        this.baustandAnfang = baustandAnfang;
        this.baustandEnde = baustandEnde;
        this.typ = typ;
        this.faelligAb = faelligAb;
        this.faelligBis = faelligBis;
        this.einheit = einheit;
        this.bosNrVon = bosNrVon;
        this.bosNrNach = bosNrNach;
        this.sichtbarkeit = 1;
    }

    public BOSVerknuepfung(String leittyp, int baustandAnfang, int baustandEnde, String typ, int faelligAb, int faelligBis, String einheit, BOSNummer bosNrVon, BOSNummer bosNrNach, int sichtbarkeit) {
        this.leittyp = leittyp;
        this.baustandAnfang = baustandAnfang;
        this.baustandEnde = baustandEnde;
        this.typ = typ;
        this.faelligAb = faelligAb;
        this.faelligBis = faelligBis;
        this.einheit = einheit;
        this.bosNrVon = bosNrVon;
        this.bosNrNach = bosNrNach;
        this.sichtbarkeit = sichtbarkeit;
    }

    public String getTyp() {
        return this.typ;
    }

    public int getFaelligAb() {
        return this.faelligAb;
    }

    public int getFaelligBis() {
        return this.faelligBis;
    }

    public String getEinheit() {
        return this.einheit;
    }

    public int getSichtbarkeit() {
        return this.sichtbarkeit;
    }

    public boolean isDynamicPosition() {
        return this.sichtbarkeit == 0;
    }

    public boolean isValid(String leittypValue, BOSNummer bosFrom, int baustand) {
        String testLeit = this.getLeittyp().trim();
        BOSNummer testNum = this.getBosNrVon();
        int testBauAnf = this.getBaustandAnfang();
        int testBauEnd = this.getBaustandEnde();
        boolean returnValue = true;
        if (!testLeit.equals(leittypValue)) {
            returnValue = false;
        }
        if (testNum.getBosNr() != bosFrom.getBosNr()) {
            returnValue = false;
        }
        if (testBauEnd == 0) {
            if (testBauAnf > baustand) {
                returnValue = false;
            }
        } else if (testBauAnf > baustand || testBauEnd <= baustand) {
            returnValue = false;
        }
        return returnValue;
    }

    public boolean isValidWiederholungswert(String leittypValue, BOSNummer bosFrom, BOSNummer bosTo, int ab, int bis) {
        String testLeit = this.getLeittyp().trim();
        BOSNummer testNumFrom = this.getBosNrVon();
        BOSNummer testNumTo = this.getBosNrNach();
        int testFaelligAb = this.getFaelligAb();
        int testFaelligBis = this.getFaelligBis();
        if (!testLeit.equals(leittypValue)) {
            return false;
        }
        if (!testNumFrom.equals(bosFrom)) {
            return false;
        }
        if (!testNumTo.equals(bosTo)) {
            return false;
        }
        if (testFaelligAb != ab) {
            return false;
        }
        return testFaelligBis == bis;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BOSVerknuepfung)) {
            return false;
        }
        BOSVerknuepfung val = (BOSVerknuepfung)object;
        if (!val.getLeittyp().equals(this.getLeittyp())) {
            return false;
        }
        if (!val.getBosNrVon().equals(this.getBosNrVon())) {
            return false;
        }
        if (!val.getBosNrNach().equals(this.getBosNrNach())) {
            return false;
        }
        if (val.getBaustandAnfang() != this.getBaustandAnfang()) {
            return false;
        }
        if (val.getBaustandEnde() != this.getBaustandEnde()) {
            return false;
        }
        if (val.getFaelligAb() != this.getFaelligAb()) {
            return false;
        }
        if (val.getFaelligBis() != this.getFaelligBis()) {
            return false;
        }
        if (val.getTyp() != this.getTyp()) {
            return false;
        }
        return val.getEinheit() == this.getEinheit();
    }

    public static String getAPD() {
        return APD;
    }

    public static String getASC() {
        return ASC;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public static String getPSC() {
        return PSC;
    }

    public int getBaustandAnfang() {
        return this.baustandAnfang;
    }

    public int getBaustandEnde() {
        return this.baustandEnde;
    }

    public BOSNummer getBosNrNach() {
        return this.bosNrNach;
    }

    public BOSNummer getBosNrVon() {
        return this.bosNrVon;
    }

    public String getLeittyp() {
        return this.leittyp;
    }

    public int getWiederholungswert() {
        return this.wiederholungswert;
    }

    public void setFilename(String fileName) {
        this.fileName = fileName;
    }

    public String getFilename() {
        return this.fileName;
    }
}

