/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.orderbase;

import com.bmw.gki.ka.exception.GKIException;
import com.bmw.gki.klib.api.BSIBerechnungsbasis;
import com.bmw.gki.klib.api.Fahreigenschaft;
import com.bmw.gki.klib.api.Schluesseldaten;
import com.bmw.gki.klib.api.exception.KeineArbeitswerteException;
import com.bmw.gki.klib.api.exception.NotFoundException;
import com.bmw.gki.klib.api.exception.SystemException;
import com.bmw.gki.klib.api_current.OrderBaseType;
import com.bmw.gki.klib.data.apiparams.RemainingValueData;
import com.bmw.gki.klib.data.ksd.bsi.BSIDatensatzfehlerhaftException;
import com.bmw.gki.klib.data.ksd.bsi.BSIVorziehbereich;
import com.bmw.gki.klib.data.ksd.cbs.BOSAWNummer;
import com.bmw.gki.klib.data.ksd.cbs.BOSNummer;
import com.bmw.gki.klib.data.ksd.cbs.BOSVorziehwert;
import com.bmw.gki.klib.data.orderbase.BOSPosition;
import com.bmw.gki.klib.external.cache.BOSAWNummerReader;
import com.bmw.gki.klib.external.cache.BOSNummerReader;
import com.bmw.gki.klib.external.cache.BOSVorziehwertReader;
import com.bmw.gki.klib.util.Utilities;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

public class BOSAWPosition
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final char EMPFEHLEN = '\u0001';
    public static final char BSI_FAELLIG = '\u0002';
    public static final char BSI_UNDEFINED = '\u0000';
    private BOSNummer bosNr;
    private int bosZustand;
    private Boolean selectionFlag = new Boolean(false);
    private boolean verbundFlag;
    private char kennungEmpfehlung = '\u0000';
    private BOSAWNummer bosAWNr;
    private int serviceZaehler = 0;
    private Integer restweg = null;
    private Integer einheitRestlaufleistung = null;
    private Integer einheitAbstand = null;
    private Float wertAbstand = null;
    private boolean inSI = false;
    private BOSAWPosition zuVerknuepfendeBosPosition;
    private Vector<BOSAWPosition> verknuepfungsliste = new Vector();
    public static final int BOS_ID_STANDARDUMFANG = 99999;
    public static final int BOS_ID_HU = 32;
    public static final int BOS_ID_AU = 33;
    private float vorziehwert;
    private boolean isSSI;
    private boolean isUebergabedurchsicht = false;
    private Integer dueDateYear = null;
    private Integer dueDateMonth = null;
    private BOSPosition bosPosition = null;
    private boolean bosAWNummerNotFound;
    private boolean isFestSelektiert = false;

    private BOSAWPosition(BOSNummer bosNr, String leittyp, int baustand, boolean isSSI) throws GKIException {
        this.isSSI = isSSI;
        this.bosNr = bosNr;
        try {
            this.bosAWNr = BOSAWNummerReader.find(leittyp, bosNr, baustand);
            this.bosAWNummerNotFound = false;
        }
        catch (KeineArbeitswerteException e) {
            this.bosAWNr = this.createNotDefinedBosAwNumber(leittyp, bosNr, baustand);
            this.bosAWNummerNotFound = true;
        }
    }

    private BOSAWNummer createNotDefinedBosAwNumber(String leittyp, BOSNummer bosNr, int baustand) {
        BOSAWNummer bosAwNumber = new BOSAWNummer(leittyp, bosNr, baustand, baustand, null, null, null, null, null, null, null, null);
        return bosAwNumber;
    }

    public BOSAWPosition(BOSPosition bosPosition, String leittyp, int baustand, boolean isSSI) throws GKIException {
        this.isSSI = isSSI;
        this.bosPosition = bosPosition;
        this.serviceZaehler = (int)bosPosition.getServiceZaehler();
        this.restweg = new Integer(bosPosition.getRestweg());
        if (bosPosition.getDueDateYear() != 2063) {
            this.dueDateYear = new Integer(bosPosition.getDueDateYear());
        }
        if (bosPosition.getDueDateMonth() != 15) {
            this.dueDateMonth = new Integer(bosPosition.getDueDateMonth());
        }
        this.bosNr = bosPosition.getBosNr();
        this.einheitRestlaufleistung = new Integer(bosPosition.getEinheitRestlaufleistung());
        this.einheitAbstand = new Integer(bosPosition.getEinheitAbstand());
        this.wertAbstand = new Float(bosPosition.getWertAbstand());
        try {
            this.bosAWNr = BOSAWNummerReader.find(leittyp, this.bosNr, baustand);
            this.bosAWNummerNotFound = false;
        }
        catch (KeineArbeitswerteException e) {
            this.bosAWNr = this.createNotDefinedBosAwNumber(leittyp, this.bosNr, baustand);
            this.bosAWNummerNotFound = true;
        }
        this.bosZustand = (int)bosPosition.getBosZustand();
        this.isUebergabedurchsicht = bosPosition.isUebergabeDurchsicht();
    }

    public BOSAWPosition(OrderBaseType.ServiceInformation.TimeLine.CbsList.ConditionBasedService conditionBasedService, String leittyp, int baustand, boolean isSSI) throws GKIException {
        this.isSSI = isSSI;
        this.serviceZaehler = new Long(conditionBasedService.isSetServiceCounter() ? conditionBasedService.getServiceCounter() : 0L).intValue();
        if (conditionBasedService.getRemainingDistance() != null) {
            this.restweg = Integer.getInteger(conditionBasedService.getRemainingDistance().getUnits());
        }
        int bosNummer = 0;
        if (conditionBasedService.getIdentifier() != null) {
            bosNummer = Integer.parseInt(conditionBasedService.getIdentifier());
        }
        this.bosNr = BOSNummerReader.find(bosNummer);
        try {
            this.bosAWNr = BOSAWNummerReader.find(leittyp, this.bosNr, baustand);
            this.bosAWNummerNotFound = false;
        }
        catch (KeineArbeitswerteException e) {
            this.bosAWNr = this.createNotDefinedBosAwNumber(leittyp, this.bosNr, baustand);
            this.bosAWNummerNotFound = true;
        }
        this.selectionFlag = new Boolean(conditionBasedService.isSelectionFlag());
        this.verbundFlag = conditionBasedService.isAssociatedLabourOperation();
        List<String> linkedCBSPositions = conditionBasedService.getLinkedCBSPositions();
        if (linkedCBSPositions != null && !linkedCBSPositions.isEmpty()) {
            for (String element : linkedCBSPositions) {
                this.addChild(BOSNummerReader.find(new Integer(element)), leittyp, baustand, isSSI);
            }
        }
        this.setFestSelektiert(conditionBasedService.isIsUnselectable());
    }

    public static BOSAWPosition standardUmfang(String leittyp, int baustand, boolean isSSI) throws GKIException {
        BOSAWPosition bosAWPosition = new BOSAWPosition(BOSNummerReader.find(99999), leittyp, baustand, isSSI);
        return bosAWPosition;
    }

    public int getBosZustand() {
        return this.bosZustand;
    }

    public Boolean getSelectionFlag() {
        return this.selectionFlag;
    }

    public String getBosBezeichnung(Locale locale) throws GKIException {
        return this.getBosNr().getBezeichnung(locale);
    }

    public int getServiceZaehler() {
        return this.serviceZaehler;
    }

    public boolean getVerbundFlag() {
        return this.verbundFlag;
    }

    public char getKennungEmpfehlung() {
        return this.kennungEmpfehlung;
    }

    public void setKennungEmpfehlung(char kennungEmpfehlung) {
        this.kennungEmpfehlung = kennungEmpfehlung;
    }

    public void setSelectionFlag(Boolean value) {
        this.selectionFlag = value;
    }

    public void setVerbundFlag(boolean value) {
        this.verbundFlag = value;
    }

    public BOSNummer getBosNr() {
        return this.bosNr;
    }

    public int getEinheitRestlaufleistung() {
        if (this.einheitRestlaufleistung != null) {
            return this.einheitRestlaufleistung;
        }
        if (this.zuVerknuepfendeBosPosition != null) {
            return this.zuVerknuepfendeBosPosition.getEinheitRestlaufleistung();
        }
        return 65535;
    }

    public int getEinheitAbstand() {
        if (this.einheitAbstand != null) {
            return this.einheitAbstand;
        }
        if (this.zuVerknuepfendeBosPosition != null) {
            return this.zuVerknuepfendeBosPosition.getEinheitAbstand();
        }
        return 65535;
    }

    public float getWertAbstand() {
        if (this.wertAbstand != null) {
            return this.wertAbstand.floatValue();
        }
        if (this.zuVerknuepfendeBosPosition != null) {
            return this.zuVerknuepfendeBosPosition.getWertAbstand();
        }
        return 65535.0f;
    }

    public RemainingValueData getRestlauf(boolean isMiles, Date keyUpdateDate, int shortTimeDrivingPerformance) {
        return this.getRestlauf(isMiles, keyUpdateDate, shortTimeDrivingPerformance, 5);
    }

    public RemainingValueData getRestlauf(boolean isMiles, Date keyUpdateDate, int shortTimeDrivingPerformance, int datetype) throws SystemException {
        RemainingValueData remainingValueData = new RemainingValueData();
        if (this.zuVerknuepfendeBosPosition != null) {
            return this.zuVerknuepfendeBosPosition.getRestlauf(isMiles, keyUpdateDate, shortTimeDrivingPerformance, datetype);
        }
        float value = this.getRestweg();
        if (this.getRestweg() == 65535 && !this.isDueDate()) {
            return null;
        }
        if (this.isCombinedCBS()) {
            remainingValueData.setEarliestDueType(this.determineEarliestDueTypeForCombinedCBS(keyUpdateDate, shortTimeDrivingPerformance));
            float valueTime = this.determineDueDateInRemainingDays(keyUpdateDate);
            if (datetype == 2) {
                valueTime /= 30.0f;
            }
            remainingValueData.setRemainingTimeValue(new Integer(Math.round(valueTime)));
            if (isMiles && this.einheitRestlaufleistung == 1) {
                value = (int)Utilities.roundDistance(this.getEinheitAbstand(), Utilities.convertToMiles(value));
            }
            remainingValueData.setRemainingDistanceValue(new Integer(Math.round(value)));
        } else {
            if (this.isDueDate()) {
                value = this.determineDueDateInRemainingDays(keyUpdateDate);
                if (datetype == 2) {
                    value /= 30.0f;
                }
                remainingValueData.setRemainingTimeValue(new Integer(Math.round(value)));
                remainingValueData.setEarliestDueType(2);
            } else if (this.einheitRestlaufleistung == 2) {
                value = this.getWertAbstand();
                switch (this.getEinheitAbstand()) {
                    case 0: {
                        if (value != 1.0f) break;
                        break;
                    }
                    case 1: {
                        if (value == 1.0f) {
                            // empty if block
                        }
                        value *= 7.0f;
                        break;
                    }
                    case 2: {
                        if (value == 1.0f) {
                            // empty if block
                        }
                        value *= 30.0f;
                        break;
                    }
                    case 3: {
                        if (value == 1.0f) {
                            // empty if block
                        }
                        value = value * 12.0f * 30.0f;
                    }
                }
                if (datetype == 2) {
                    value /= 30.0f;
                }
                remainingValueData.setRemainingTimeValue(new Integer(Math.round(value)));
                remainingValueData.setEarliestDueType(2);
            }
            if (this.einheitRestlaufleistung == 1) {
                if (isMiles && !this.getBOSPosition().isMiles()) {
                    value = (int)Utilities.roundDistance(this.getEinheitAbstand(), Utilities.convertToMiles(value));
                } else if (!isMiles && this.getBOSPosition().isMiles()) {
                    value = (int)Utilities.roundDistance(this.getEinheitAbstand(), Utilities.convertToKm(value));
                }
                remainingValueData.setRemainingDistanceValue(new Integer(Math.round(value)));
                remainingValueData.setEarliestDueType(1);
            }
        }
        return remainingValueData;
    }

    public int getRestweg() {
        if (this.restweg != null) {
            return this.restweg;
        }
        if (this.zuVerknuepfendeBosPosition != null) {
            return this.zuVerknuepfendeBosPosition.getRestweg();
        }
        return 65535;
    }

    public int getRestweg(Date keyUpdateDate) {
        if (this.getEinheitRestlaufleistung() == 2 && this.isDueDate()) {
            return this.determineDueDateInRemainingDays(keyUpdateDate);
        }
        return this.getRestweg();
    }

    public String getBosAwNr() {
        return this.verbundFlag ? this.getAWNrVerbundArbeit() : this.getBosAwNrHauptArbeit();
    }

    private String getBosAwNrHauptArbeit() {
        return this.isSSI ? this.bosAWNr.getSsiAwNrHaupt() : this.bosAWNr.getAwNrHaupt();
    }

    private String getAWNrVerbundArbeit() {
        return this.isSSI ? this.bosAWNr.getSsiAwNrVerbund() : this.bosAWNr.getAwNrVerbund();
    }

    public String getBosAwWert() {
        return this.verbundFlag ? this.getAwWertVerbund() : this.getAwWertHaupt();
    }

    private String getAwWertHaupt() {
        return this.isSSI ? this.bosAWNr.getSsiAwWertHaupt() : this.bosAWNr.getAwWertHaupt();
    }

    private String getAwWertVerbund() {
        return this.isSSI ? this.bosAWNr.getSsiAwWertVerbund() : this.bosAWNr.getAwWertVerbund();
    }

    public BOSAWPosition getZuVerknuepfendeBosPosition() {
        return this.zuVerknuepfendeBosPosition;
    }

    public Vector<BOSAWPosition> getVerknuepfungsliste() {
        return this.verknuepfungsliste;
    }

    public void setKennungEmpfehlung(String region, Date keyUpdateDate, int shortTimeDrivingPerformance, Fahreigenschaft fahreigenschaft, BSIBerechnungsbasis berechnungsbasis) throws GKIException {
        try {
            if (berechnungsbasis != null && berechnungsbasis.hasBsiVorziehbereich(this.getBosNr())) {
                this.inSI = true;
                this.bestimmeFaelligkeit(region, keyUpdateDate, fahreigenschaft, berechnungsbasis, shortTimeDrivingPerformance);
            } else {
                BOSNummer cbsnr = this.getBosNr();
                BOSVorziehwert w = BOSVorziehwertReader.find(region, cbsnr);
                this.vorziehwert = w.getWert();
                double compareVorziehwert = !w.getEinheit().equals("w") && this.getBOSPosition().isMiles() ? Utilities.convertToMiles(this.vorziehwert) : (double)this.vorziehwert;
                float restweg1 = this.berechneRestwegOhneServicePaket(keyUpdateDate, shortTimeDrivingPerformance);
                if ((double)restweg1 <= compareVorziehwert) {
                    this.kennungEmpfehlung = '\u0001';
                }
            }
        }
        catch (NotFoundException ex) {
            // empty catch block
        }
    }

    public int determineEarliestDueTypeForCombinedCBS(Date keyUpdateDate, int shortTimeDrivingPerformance) {
        if (this.wertAbstand.floatValue() < 0.0f) {
            return 1;
        }
        Calendar zielterminWeg = Calendar.getInstance();
        zielterminWeg.setTime(keyUpdateDate);
        int year = zielterminWeg.get(1);
        int month = zielterminWeg.get(2) + 1;
        int date = zielterminWeg.get(5);
        zielterminWeg.set(year, month, date);
        int restlaufstrecke = 0;
        if (this.restweg != null) {
            restlaufstrecke = this.restweg;
        }
        double kurzzeitwert = shortTimeDrivingPerformance / 7;
        int days = (int)Math.floor((double)restlaufstrecke / kurzzeitwert);
        zielterminWeg.add(5, days);
        Calendar zielterminZeit = Calendar.getInstance();
        zielterminZeit.set(this.dueDateYear, this.dueDateMonth, 1);
        if (zielterminZeit.before(zielterminWeg)) {
            return 2;
        }
        return 1;
    }

    public boolean hasZuVerknuepfendeBosPosition() {
        return this.zuVerknuepfendeBosPosition != null;
    }

    public boolean isTuev() {
        return this.getBosNr().getBosNr() == 32;
    }

    public boolean isAu() {
        return this.getBosNr().getBosNr() == 33;
    }

    public boolean hasVerknuepfungsliste() {
        return this.verknuepfungsliste.size() > 0;
    }

    public Integer getDueDateYear() {
        return this.dueDateYear;
    }

    public void setDueDateYear(Integer dueDateYear) {
        this.dueDateYear = dueDateYear;
    }

    public Integer getDueDateMonth() {
        return this.dueDateMonth;
    }

    public void setDueDateMonth(Integer dueDateMonth) {
        this.dueDateMonth = dueDateMonth;
    }

    public BOSAWPosition addChild(BOSNummer bosNummer, String leittyp, int baustand, boolean isSSI) throws GKIException {
        BOSAWPosition bosAWPosition = new BOSAWPosition(bosNummer, leittyp, baustand, isSSI);
        bosAWPosition.bosZustand = this.bosZustand;
        bosAWPosition.zuVerknuepfendeBosPosition = this;
        this.verknuepfungsliste.add(bosAWPosition);
        return bosAWPosition;
    }

    public Date getCBSDatum(Schluesseldaten schluesseldaten, Date keyUpdateDate, int shortTimeDrivingPerformance) {
        GregorianCalendar calendar = new GregorianCalendar();
        if (schluesseldaten != null) {
            if (schluesseldaten.getLetzteAktualisierung() != null) {
                calendar.setTime(schluesseldaten.getLetzteAktualisierung());
            } else {
                calendar.setTime(schluesseldaten.getEinleseDatum());
            }
        }
        if (!this.getSelectionFlag().booleanValue()) {
            calendar.add(5, this.getRestlauf(false, keyUpdateDate, shortTimeDrivingPerformance).getRemainingTimeValue());
        } else {
            calendar.add(5, this.getBOSPosition().getForecastRemainingTime().intValue() * 30);
        }
        return calendar.getTime();
    }

    public int determineDueDateInRemainingDays(Date keyUpdateDate) {
        Calendar letzteAktualisierung = Calendar.getInstance();
        letzteAktualisierung.setTime(keyUpdateDate);
        int year = letzteAktualisierung.get(1);
        int month = letzteAktualisierung.get(2) + 1;
        int date = letzteAktualisierung.get(5);
        int diffyear = this.dueDateYear - year;
        int diffmonth = this.dueDateMonth - month;
        int diffday = 1 - date;
        return (diffyear * 12 + diffmonth) * 30 + diffday;
    }

    public boolean isDueDate() {
        return this.dueDateYear != null && this.dueDateMonth != null && this.dueDateYear > 2000 && 0 < this.dueDateMonth && this.dueDateMonth < 13;
    }

    public boolean isCombinedCBS() {
        return this.getEinheitRestlaufleistung() == 1 && this.isDueDate();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(80);
        buffer.append(Utilities.toString(this.getBosNr().getBosNr(), 5) + " ");
        buffer.append(Utilities.rpad(this.getBosNr().getBezeichnung(Locale.UK), 20) + " ");
        if (this.selectionFlag.booleanValue()) {
            buffer.append(this.selectionFlag != false ? "X " : "  ");
        } else {
            buffer.append("  ");
        }
        switch (this.bosZustand) {
            case 0: {
                buffer.append("gruen ");
                break;
            }
            case 1: {
                buffer.append("gelb  ");
                break;
            }
            case 2: {
                buffer.append("rot   ");
                break;
            }
            default: {
                buffer.append("----- ");
            }
        }
        if (this.kennungEmpfehlung == '\u0001') {
            buffer.append("Empf. ");
        } else {
            buffer.append("      ");
        }
        block5 : switch (this.getEinheitRestlaufleistung()) {
            case 0: {
                buffer.append("-------- ------ ");
                break;
            }
            case 1: {
                switch (this.getEinheitAbstand()) {
                    case 0: {
                        buffer.append(Utilities.toString(Math.round(this.getWertAbstand() * 10.0f), 8) + " km     ");
                        break block5;
                    }
                    case 1: {
                        buffer.append(Utilities.toString(Math.round(this.getWertAbstand() * 100.0f), 8) + " km     ");
                        break block5;
                    }
                    case 2: {
                        buffer.append(Utilities.toString(Math.round(this.getWertAbstand() * 1000.0f), 8) + " km     ");
                        break block5;
                    }
                    case 3: {
                        buffer.append(Utilities.toString(Math.round(this.getWertAbstand() * 10000.0f), 8) + " km     ");
                        break block5;
                    }
                }
                buffer.append("-------- km     ");
                break;
            }
            case 2: {
                switch (this.getEinheitAbstand()) {
                    case 0: {
                        buffer.append(Utilities.toString(Math.round(this.getWertAbstand()), 8) + " Tage   ");
                        break block5;
                    }
                    case 1: {
                        buffer.append(Utilities.toString(Math.round(this.getWertAbstand()), 8) + " Wochen ");
                        break block5;
                    }
                    case 2: {
                        buffer.append(Utilities.toString(Math.round(this.getWertAbstand()), 8) + " Monate ");
                        break block5;
                    }
                    case 3: {
                        buffer.append(Utilities.toString(Math.round(this.getWertAbstand()), 8) + " Jahre  ");
                        break block5;
                    }
                }
                buffer.append("-------- Zeit   ");
                break;
            }
            default: {
                buffer.append("-------- ------ ");
            }
        }
        if (this.selectionFlag.booleanValue()) {
            buffer.append(this.verbundFlag ? "V " : "H ");
        } else {
            buffer.append("  ");
        }
        buffer.append(this.hasVerknuepfungsliste() ? "C " : "  ");
        buffer.append(this.hasZuVerknuepfendeBosPosition() ? "P " : "  ");
        buffer.append(this.getBosAwNrHauptArbeit() + "/" + this.getAWNrVerbundArbeit());
        return buffer.toString();
    }

    public void setFestSelektiert(boolean wert) {
        this.isFestSelektiert = wert;
    }

    public boolean isFestSelektiert() {
        return this.isFestSelektiert;
    }

    public boolean isAusserhalbServicePaketUmfang() {
        return this.getSelectionFlag() != false && !this.isFestSelektiert();
    }

    private int berechneRestwegOhneServicePaket(Date keyUpdateDate, int shortTimeDrivingPerformance) {
        int restweglocal = this.getRestweg();
        if (!this.isCombinedCBS() && this.isDueDate()) {
            restweglocal = this.determineDueDateInRemainingDays(keyUpdateDate);
        }
        return restweglocal;
    }

    private float getVorziehwert(String region, Fahreigenschaft fahreigenschaft, BSIBerechnungsbasis berechnungsbasis, int typ) throws GKIException, BSIDatensatzfehlerhaftException {
        BOSNummer cbsnr = this.getBosNr();
        if (berechnungsbasis == null) {
            BOSVorziehwert w = BOSVorziehwertReader.find(region, cbsnr);
            return w.getWert();
        }
        BSIVorziehbereich vb = (BSIVorziehbereich)berechnungsbasis.getBSIVorziehbereich().get(cbsnr.getIdString());
        if (typ == 65535) {
            typ = this.getEinheitRestlaufleistung();
        }
        float vorziehwert1 = vb.ermittleWert(typ);
        return vorziehwert1 *= berechnungsbasis.ermittleFaktor(fahreigenschaft, typ);
    }

    public void bestimmeFaelligkeit(String region, Date keyUpdateDate, Fahreigenschaft fahreigenschaft, BSIBerechnungsbasis berechnungsbasis, int shortTimeDrivingPerformance) throws GKIException {
        if (this.isCombinedCBS()) {
            if (this.bestimmeFaelligBeiKombiniert(region, keyUpdateDate, fahreigenschaft, berechnungsbasis, shortTimeDrivingPerformance)) {
                this.kennungEmpfehlung = (char)2;
                this.setFestSelektiert(true);
            }
        } else if (this.isDueDate()) {
            int days = this.determineDueDateInRemainingDays(keyUpdateDate);
            this.vorziehwert = this.getVorziehwert(region, fahreigenschaft, berechnungsbasis, 2);
            if ((float)days <= this.vorziehwert * 7.0f) {
                this.kennungEmpfehlung = (char)2;
                this.setFestSelektiert(true);
            }
        } else {
            int restweglocal = this.getRestweg();
            this.vorziehwert = this.getVorziehwert(region, fahreigenschaft, berechnungsbasis, 65535);
            if (this.getBOSPosition().isMiles()) {
                this.vorziehwert = (int)Utilities.convertToMiles(this.vorziehwert);
            }
            if ((float)restweglocal <= this.vorziehwert) {
                this.kennungEmpfehlung = (char)2;
                this.setFestSelektiert(true);
            }
        }
    }

    private boolean bestimmeFaelligBeiKombiniert(String region, Date keyUpdateDate, Fahreigenschaft fahreigenschaft, BSIBerechnungsbasis berechnungsbasis, int shortTimeDrivingPerformance) throws GKIException {
        double compareVorziehwert;
        this.vorziehwert = this.getVorziehwert(region, fahreigenschaft, berechnungsbasis, 1);
        double d = compareVorziehwert = this.getBOSPosition().isMiles() ? Utilities.convertToMiles(this.vorziehwert) : (double)this.vorziehwert;
        if ((double)this.getRestweg() <= compareVorziehwert) {
            return true;
        }
        int days = this.determineDueDateInRemainingDays(keyUpdateDate);
        this.vorziehwert = this.getVorziehwert(region, fahreigenschaft, berechnungsbasis, 2);
        if ((float)days <= this.vorziehwert * 7.0f) {
            this.kennungEmpfehlung = (char)2;
            this.setFestSelektiert(true);
        }
        return false;
    }

    public boolean isUebergabedurchsicht() {
        return this.isUebergabedurchsicht;
    }

    public boolean isRecommended() {
        boolean value = false;
        value = this.getBosZustand() == 0 && this.getKennungEmpfehlung() == '\u0001';
        return value;
    }

    public float getVorziehwert() {
        return this.vorziehwert;
    }

    public void setSI(boolean included) {
        this.isSSI = included;
    }

    public boolean isInSI() {
        return this.inSI;
    }

    public BOSPosition getBOSPosition() {
        return this.bosPosition;
    }

    public boolean bosAWNummerFound() {
        return !this.bosAWNummerNotFound;
    }
}

