/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.orderbase;

import com.bmw.gki.ka.exception.GKIException;
import com.bmw.gki.klib.api.exception.BosNotFoundException;
import com.bmw.gki.klib.api_current.KeyDataAnalysedType;
import com.bmw.gki.klib.api_current.impl.KeyDataAnalysedTypeImpl;
import com.bmw.gki.klib.data.ksd.cbs.BOSNummer;
import com.bmw.gki.klib.external.cache.BOSNummerReader;
import com.bmw.gki.klib.util.StatusMeasureReader;
import com.bmw.gki.logging.GKILogManager;
import java.io.Serializable;
import org.apache.commons.logging.Log;

public class BOSPosition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Log log = GKILogManager.getInstance().getLogger(BOSPosition.class);
    public static final byte TUEV = 32;
    public static final byte AU = 33;
    public static final int GRUEN = 0;
    public static final int GELB = 1;
    public static final int ROT = 2;
    public static final int CBR = 255;
    protected static final int KM_10 = 0;
    protected static final int KM_100 = 1;
    protected static final int KM_1000 = 2;
    protected static final int KM_10000 = 3;
    public static final int TAGE = 0;
    public static final int WOCHEN = 1;
    public static final int MONATE = 2;
    public static final int JAHRE = 3;
    public static final int KEINE = 0;
    public static final int KM = 1;
    public static final int ZEIT = 2;
    public static final char EMPFEHLEN = '\u0001';
    public static final int UNDEFINED = 65535;
    private BOSNummer bosNr;
    private boolean isMiles = false;
    private KeyDataAnalysedType.CbsBaseData.ConditionBasedService serviceData;
    public static final int UEBERGABEDURCHSICHT = 20;

    public BOSPosition(KeyDataAnalysedType.CbsBaseData.ConditionBasedService serviceData, boolean isMiles) throws GKIException {
        this.serviceData = serviceData;
        this.isMiles = isMiles;
        if (!serviceData.isSetCbsId()) {
            throw new BosNotFoundException("CBS id undefined");
        }
        this.bosNr = BOSNummerReader.find(serviceData.getCbsId().intValue());
    }

    public BOSPosition(int cbsIdentifier, int dueDateYear, int dueDateMonth, int cbsState) throws GKIException {
        this.bosNr = BOSNummerReader.find(cbsIdentifier);
        log.debug((Object)("bosNr: " + this.bosNr));
        this.serviceData = new KeyDataAnalysedTypeImpl.CbsBaseDataImpl.ConditionBasedServiceImpl();
        this.serviceData.setCbsId(Long.valueOf(cbsIdentifier));
        this.serviceData.setDueYear(dueDateYear);
        this.serviceData.setDueMonth(dueDateMonth);
        this.serviceData.setCbsState(cbsState);
        this.serviceData.setServiceCounter(65535L);
        this.serviceData.setAvailability(65535);
        this.serviceData.setUnitCBS(65535);
        this.serviceData.setValueDistance(65535.0);
    }

    public BOSPosition(KeyDataAnalysedType.CbsBaseData.ConditionBasedService serviceData) throws GKIException {
        this(serviceData, false);
    }

    public long getBosZustand() {
        if (this.serviceData != null) {
            return (int)this.serviceData.getCbsState();
        }
        return 0L;
    }

    public long getServiceZaehler() {
        if (this.serviceData != null) {
            return this.serviceData.getServiceCounter();
        }
        return 0L;
    }

    public BOSNummer getBosNr() {
        return this.bosNr;
    }

    public int getEinheitRestlaufleistung() {
        int einheitRestlaufleistung = this.serviceData.getUnitCBS();
        if (einheitRestlaufleistung == 3) {
            einheitRestlaufleistung = 1;
        }
        return einheitRestlaufleistung;
    }

    public char getStatus() {
        return this.serviceData.getCcTelegram().toString().charAt(0);
    }

    public float getWertAbstand() {
        return (float)this.serviceData.getValueDistance();
    }

    public int getEinheitAbstand() {
        if (this.serviceData != null && this.serviceData.getUnitFactor() != null) {
            return new Double(this.serviceData.getUnitFactor()).intValue();
        }
        return 0;
    }

    public int getVerfuegbarkeit() {
        return this.serviceData.getAvailability();
    }

    public int getRestweg() {
        float restweg = this.getWertAbstand();
        block0 : switch (this.getEinheitRestlaufleistung()) {
            case 0: {
                break;
            }
            case 1: {
                switch (this.getEinheitAbstand()) {
                    case 0: {
                        restweg *= 10.0f;
                        break;
                    }
                    case 1: {
                        restweg *= 100.0f;
                        break;
                    }
                    case 2: {
                        restweg *= 1000.0f;
                        break;
                    }
                    case 3: {
                        restweg *= 10000.0f;
                        break;
                    }
                }
                restweg = Math.round(restweg);
                break;
            }
            case 2: {
                switch (this.getEinheitAbstand()) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        restweg *= 7.0f;
                        break block0;
                    }
                    case 2: {
                        restweg *= 30.0f;
                        break block0;
                    }
                    case 3: {
                        restweg *= 365.0f;
                        break block0;
                    }
                }
                break;
            }
        }
        return (int)restweg;
    }

    public int getDueDateYear() {
        int dueDateYear = 0;
        if (this.serviceData != null && this.serviceData.isSetDueYear() && this.serviceData.getDueYear() > 0) {
            dueDateYear = this.serviceData.getDueYear() + 2000;
        }
        return dueDateYear;
    }

    public int getDueDateMonth() {
        int dueDateMonth = 0;
        if (this.serviceData != null && this.serviceData.isSetDueMonth() && this.serviceData.getDueMonth() > 0) {
            dueDateMonth = this.serviceData.getDueMonth();
        }
        return dueDateMonth;
    }

    public Double getForecastRemainingDistance() {
        if (this.serviceData != null && this.serviceData.getForecastRemainingDistance() != null && this.serviceData.getForecastRemainingDistance() > 0.0) {
            return new Double(this.serviceData.getForecastRemainingDistance());
        }
        return null;
    }

    public Double getForecastRemainingTime() {
        if (this.serviceData != null && this.serviceData.getForecastRemainingTime() != null && this.serviceData.getForecastRemainingTime() > 0.0) {
            return new Double(this.serviceData.getForecastRemainingTime());
        }
        return null;
    }

    public boolean isUebergabeDurchsicht() {
        return this.bosNr.getBosNr() == 20;
    }

    public int getAvailability() {
        if (this.serviceData != null) {
            return this.serviceData.getAvailability();
        }
        return 0;
    }

    public Integer getStatusTeleserviceCall() {
        if (this.serviceData != null && this.serviceData.getStatusTeleserviceCall() != null) {
            return new Integer(this.serviceData.getStatusTeleserviceCall());
        }
        return null;
    }

    public Integer getStatusMeasure() {
        if (this.serviceData != null && this.serviceData.getStatusMeasure() != null && this.serviceData.getStatusMeasure() > 0) {
            return new Integer(this.serviceData.getStatusMeasure());
        }
        return null;
    }

    public boolean hasCorrectionFlag() {
        if (this.getStatusMeasure() == null) {
            return false;
        }
        return StatusMeasureReader.getInstance().hasFlag("statusReplacementValue", this.getStatusMeasure());
    }

    public Long getCbsId() {
        if (this.serviceData != null && this.serviceData.isSetCbsId()) {
            return new Long(this.serviceData.getCbsId());
        }
        return null;
    }

    public boolean isMiles() {
        return this.isMiles;
    }
}

