/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.xml;

import com.bmw.gki.klib.api.GKISettingsRessource;
import com.bmw.gki.klib.api.exception.XMLBearbeitungsException;
import com.bmw.gki.klib.data.xml.ServicePackageBaseResponseTransformer;
import com.bmw.gki.klib.external.cache.SSIInformationReader;
import com.bmw.gki.klib.sa_V01_00_00.OptEquipmentType;
import com.bmw.gki.klib.sa_V01_00_00.OptionalEquipmentResponse;
import com.bmw.gki.klib.sa_V01_00_00.TypeError;
import com.bmw.gki.klib.sa_V01_00_00.impl.TypeSchemaVersionReferenceImpl;
import com.bmw.gki.logging.GKILogManager;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;

public class OptionalEquipmentResponseTransformer {
    private static final Log LOG = GKILogManager.getInstance().getLogger(ServicePackageBaseResponseTransformer.class);
    private static final String ROOT_PACKAGE_NAME = "com.bmw.gki.klib.sa_";
    private OptEquipmentType optionalEquipment;
    private String ssISaCode = null;
    private boolean isSaSet = false;
    private TypeError error;

    public TypeError getError() {
        return this.error;
    }

    public OptEquipmentType getOptionalEquipmentList() {
        return this.optionalEquipment;
    }

    public String getSsiSaCode() {
        return this.ssISaCode;
    }

    public boolean isSaCodeSet() {
        return this.isSaSet;
    }

    public void transformToTyped(String xml) throws XMLBearbeitungsException {
        OptionalEquipmentResponse response = (OptionalEquipmentResponse)this.parseObject(xml);
        if (response != null) {
            if (response.isSetOptionalEquipmentList()) {
                this.optionalEquipment = response.getOptionalEquipmentList();
                List<String> saCodeList = this.optionalEquipment.getCode();
                for (int i = 0; i < saCodeList.size(); ++i) {
                    String code = saCodeList.get(i).toString();
                    if (!SSIInformationReader.isSSISA(code)) continue;
                    this.ssISaCode = code;
                    this.isSaSet = true;
                    break;
                }
            }
            this.error = response.getException();
        }
    }

    protected Object parseObject(String srcXml) throws XMLBearbeitungsException {
        Object dstObj = null;
        String version = GKISettingsRessource.getString("saVersion");
        try {
            JAXBContext jc = JAXBContext.newInstance((String)this.getJaxbPackageName(version));
            Unmarshaller u = jc.createUnmarshaller();
            dstObj = u.unmarshal((Source)new StreamSource(new StringReader(srcXml)));
        }
        catch (Exception ex) {
            LOG.fatal((Object)ex);
            String shortClassName = ClassUtils.getShortClassName(this.getClass());
            String errorText = "Error:Exception:" + ex + " - " + shortClassName + ".parseObject(" + srcXml + ")";
            throw new XMLBearbeitungsException(errorText, ex);
        }
        return dstObj;
    }

    public String transformOptionalEquipmentResponseToXml(OptionalEquipmentResponse optionalEquipmentResponse) throws XMLBearbeitungsException {
        String version = GKISettingsRessource.getString("saVersion");
        if (optionalEquipmentResponse.getSchemaRef() == null) {
            TypeSchemaVersionReferenceImpl ref = new TypeSchemaVersionReferenceImpl();
            ref.setVersion(version);
            ref.setRefSchema(GKISettingsRessource.getString("saRefSchema"));
            optionalEquipmentResponse.setSchemaRef(ref);
        }
        String xmlSource = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((String)this.getJaxbPackageName(version));
            Marshaller mSource = jc.createMarshaller();
            mSource.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            StringWriter stringWriter = new StringWriter();
            mSource.marshal((Object)optionalEquipmentResponse, (Writer)stringWriter);
            xmlSource = stringWriter.toString();
        }
        catch (Exception ex) {
            LOG.fatal((Object)"unknown error occured ", (Throwable)ex);
            String shortClassName = ClassUtils.getShortClassName(this.getClass());
            String srcObjClassName = null;
            srcObjClassName = optionalEquipmentResponse.getClass().getName();
            String errorText = "Error:Exception:" + ex + " - " + shortClassName + ".formatObjectToString(" + version + "," + srcObjClassName + ")";
            throw new XMLBearbeitungsException(errorText, ex);
        }
        return xmlSource;
    }

    private String getJaxbPackageName(String version) {
        String packageName = ROOT_PACKAGE_NAME + this.versionToPackageName(version);
        return packageName;
    }

    private String versionToPackageName(String xmlVersion) {
        String packageName = ROOT_PACKAGE_NAME;
        String version = "V" + StringUtils.replace((String)xmlVersion, (String)".", (String)"_");
        packageName = packageName + version;
        return version;
    }
}

