/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.xml.transformer;

import com.bmw.gki.klib.api.GKISettingsRessource;
import com.bmw.gki.klib.api.exception.XMLBearbeitungsException;
import com.bmw.gki.klib.data.xml.transformer.XSLCache;
import com.bmw.gki.logging.GKILogManager;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;

public class GKIXmlTransformer {
    private String sourceVersion;
    private String destinationVersion;
    private static Log log = GKILogManager.getInstance().getLogger(GKIXmlTransformer.class);

    public GKIXmlTransformer(String srcVersion, String transformToVersion) {
        this.sourceVersion = srcVersion;
        this.destinationVersion = transformToVersion;
    }

    private String transform(String xslId, String xml) throws XMLBearbeitungsException {
        String xmlTransformed = null;
        XSLCache xslCache = XSLCache.getInstance();
        xslId = new StringBuffer(xslId).append("_").append(this.sourceVersion).append("_").append(this.destinationVersion).toString();
        String xsl = GKISettingsRessource.getString(xslId);
        Transformer transformer = xslCache.retrieveXSLT(xsl);
        StringReader sourceReader = new StringReader(xml);
        StreamSource source = new StreamSource(sourceReader);
        StringWriter resultWriter = new StringWriter();
        StreamResult result = new StreamResult(resultWriter);
        try {
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            String message = "GKIXmlTransformer transform - XML failure";
            XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
            log.fatal((Object)("error code: " + be.getErrorCode() + " " + message), (Throwable)e);
            throw be;
        }
        xmlTransformed = resultWriter.toString();
        return xmlTransformed;
    }

    public String transformInterpretKey(String srcXml) {
        String requestTransformed = this.transform("interpretKeyGKI", srcXml);
        return requestTransformed;
    }
}

