/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.xsd;

import com.bmw.gki.klib.api.AuftragsbasisGrunddatenIF;
import com.bmw.gki.klib.api.Schluesseldaten;
import com.bmw.gki.klib.api.exception.XMLBearbeitungsException;
import com.bmw.gki.klib.api_current.OrderBaseType;
import com.bmw.gki.klib.api_current.impl.OrderBaseTypeImpl;
import com.bmw.gki.klib.config.GKISettings;
import com.bmw.gki.klib.data.orderbase.BOSAWPosition;
import com.bmw.gki.klib.data.orderbase.SchluesseldatenE65;
import com.bmw.gki.klib.data.xsd.ConditionBasedService;
import com.bmw.gki.logging.GKILogManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;

public class CbsList {
    private static Log log = GKILogManager.getInstance().getLogger(CbsList.class);

    public static OrderBaseType.ServiceInformation.TimeLine.CbsList createCbsList(AuftragsbasisGrunddatenIF ab, GKISettings usersettings) {
        OrderBaseTypeImpl.ServiceInformationImpl.TimeLineImpl.CbsListImpl cbsListType = new OrderBaseTypeImpl.ServiceInformationImpl.TimeLineImpl.CbsListImpl();
        try {
            Schluesseldaten sd = ab.getSchluesseldaten();
            if (sd.isE65upward()) {
                SchluesseldatenE65 sdE65 = (SchluesseldatenE65)sd;
                ArrayList<BOSAWPosition> bosAwPositionen = new ArrayList<BOSAWPosition>(ab.getBosAwPositions());
                Date keyUpdateDate = sd.getLetzteAktualisierung();
                if (keyUpdateDate == null) {
                    keyUpdateDate = sd.getEinleseDatum();
                }
                if (bosAwPositionen != null) {
                    boolean isMiles = !usersettings.getDisplayDistance().equals("K");
                    int shortTimeDrivingPerformance = sdE65.getBOSDaten().getShortTimeDrivingPerformance();
                    List<OrderBaseType.ServiceInformation.TimeLine.CbsList.ConditionBasedService> cbsList = cbsListType.getConditionBasedService();
                    for (BOSAWPosition bosAWPosition : bosAwPositionen) {
                        OrderBaseType.ServiceInformation.TimeLine.CbsList.ConditionBasedService cbs = ConditionBasedService.createConditionBasedService(bosAWPosition, keyUpdateDate, shortTimeDrivingPerformance, isMiles, usersettings);
                        cbsList.add(cbs);
                    }
                }
            }
        }
        catch (Exception e) {
            String message = "CbsList  XML failure";
            XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
            log.fatal((Object)("error code: " + be.getErrorCode() + " " + message));
            throw be;
        }
        return cbsListType;
    }
}

