/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.xsd;

import com.bmw.gki.ka.exception.GKIException;
import com.bmw.gki.klib.api.AuftragsbasisGrunddatenIF;
import com.bmw.gki.klib.api.exception.XMLBearbeitungsException;
import com.bmw.gki.klib.api_current.OrderBaseType;
import com.bmw.gki.klib.api_current.impl.OrderBaseTypeImpl;
import com.bmw.gki.klib.config.GKISettings;
import com.bmw.gki.klib.data.apiparams.KeyDataHelper;
import com.bmw.gki.klib.data.orderbase.SchluesseldatenE65;
import com.bmw.gki.klib.data.xsd.Mileage;
import com.bmw.gki.klib.util.Utilities;
import com.bmw.gki.logging.GKILogManager;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Dates {
    private static Log log = GKILogManager.getInstance().getLogger(Dates.class);
    public static final String CLASS_NAME = "Dates";
    public static final String TAG_DATES = "dates";
    public static final String TAG_LEGAL_INSPECTION_DATE = "legalInspectionDate";
    public static final String TAG_EMISSION_CONTROL_INSPECTION_DATE = "emissionControlInspectionDate";
    public static final String TAG_TECHNICAL_CHECK_DISTANCE = "technicalCheckDistance";
    public static final String TAG_BREAK_FLUIDDATE = "breakFluidDate";
    private String legalInspectionDate = null;
    private String emissionControlInspectionDate = null;
    private String technicalCheckDistance = null;
    private String technicalCheckDistanceUnits = null;
    private String breakFluidDate = null;

    public Dates(Node node) throws GKIException {
        this.read(node);
    }

    public String getBreakFluidDate() {
        return this.breakFluidDate;
    }

    public String getEmissionControlInspectionDate() {
        return this.emissionControlInspectionDate;
    }

    public String getLegalInspectionDate() {
        return this.legalInspectionDate;
    }

    public String getTechnicalCheckDistance() {
        return this.technicalCheckDistance;
    }

    public String getTechnicalCheckDistanceUnits() {
        return this.technicalCheckDistanceUnits;
    }

    public void setBreakFluidDate(String breakFluidDate) {
        this.breakFluidDate = breakFluidDate;
    }

    public void setEmissionControlInspectionDate(String emissionControlInspectionDate) {
        this.emissionControlInspectionDate = emissionControlInspectionDate;
    }

    public void setLegalInspectionDate(String legalInspectionDate) {
        this.legalInspectionDate = legalInspectionDate;
    }

    public void setTechnicalCheckDistance(String technicalCheckDistance) {
        this.technicalCheckDistance = technicalCheckDistance;
    }

    public void setTechnicalCheckDistanceUnits(String technicalCheckDistanceUnits) {
        this.technicalCheckDistanceUnits = technicalCheckDistanceUnits;
    }

    public Date getLegalInspectionDateAsDate() {
        if (this.getLegalInspectionDate() != null) {
            return Utilities.getXSDStringToDate(this.getLegalInspectionDate());
        }
        return null;
    }

    public Date getEmissionControlInspectionDateAsDate() {
        if (this.getEmissionControlInspectionDate() != null) {
            return Utilities.getXSDStringToDate(this.getEmissionControlInspectionDate());
        }
        return null;
    }

    public Date getBreakFluidDateAsDate() {
        if (this.getBreakFluidDate() != null) {
            return Utilities.getXSDStringToDate(this.getBreakFluidDate());
        }
        return null;
    }

    private void read(Node node) throws GKIException {
        try {
            Node tmpNode = null;
            String name = null;
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                tmpNode = children.item(i);
                name = Utilities.getLocalName(tmpNode.getNodeName());
                if (name.equals(TAG_LEGAL_INSPECTION_DATE)) {
                    if (tmpNode.getFirstChild() == null || tmpNode.getFirstChild().getNodeType() != 3) continue;
                    this.setLegalInspectionDate(tmpNode.getFirstChild().getNodeValue());
                    continue;
                }
                if (name.equals(TAG_EMISSION_CONTROL_INSPECTION_DATE)) {
                    if (tmpNode.getFirstChild() == null || tmpNode.getFirstChild().getNodeType() != 3) continue;
                    this.setEmissionControlInspectionDate(tmpNode.getFirstChild().getNodeValue());
                    continue;
                }
                if (name.equals(TAG_TECHNICAL_CHECK_DISTANCE)) {
                    if (tmpNode.getAttributes().getNamedItem("units") != null) {
                        this.technicalCheckDistanceUnits = tmpNode.getAttributes().getNamedItem("units").getNodeValue();
                    }
                    if (tmpNode.getFirstChild() == null || tmpNode.getFirstChild().getNodeType() != 3) continue;
                    this.setTechnicalCheckDistance(tmpNode.getFirstChild().getNodeValue());
                    continue;
                }
                if (!name.equals(TAG_BREAK_FLUIDDATE) || tmpNode.getFirstChild() == null || tmpNode.getFirstChild().getNodeType() != 3) continue;
                this.setBreakFluidDate(tmpNode.getFirstChild().getNodeValue());
            }
        }
        catch (Exception e) {
            String message = "Dates XML failure";
            XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
            log.fatal((Object)("error code: " + be.getErrorCode() + " " + message));
            throw be;
        }
    }

    public static OrderBaseType.ServiceInformation.TimeLine.Dates createDates(AuftragsbasisGrunddatenIF ab, TimeZone timeZone, GKISettings usersettings, Locale locale) throws GKIException {
        OrderBaseTypeImpl.ServiceInformationImpl.TimeLineImpl.DatesImpl element = new OrderBaseTypeImpl.ServiceInformationImpl.TimeLineImpl.DatesImpl();
        try {
            SchluesseldatenE65 sd65 = (SchluesseldatenE65)ab.getSchluesseldaten();
            if (sd65.getNextHUDate() != null) {
                element.setLegalInspectionDate(KeyDataHelper.retrieveXMLGregorianCalendar(sd65.getNextHUDate(), timeZone));
            }
            if (sd65.getNextAUDate() != null) {
                element.setEmissionControlInspectionDate(KeyDataHelper.retrieveXMLGregorianCalendar(sd65.getNextAUDate(), timeZone));
            }
            if (sd65.getNextFahrzeugcheck(usersettings) != null) {
                String fahrzeugCheck = String.valueOf(sd65.getNextFahrzeugcheck(usersettings));
                String einheitWegstrecke = usersettings.isMiles() ? "miles" : "km";
                Mileage mileage = new Mileage(fahrzeugCheck, einheitWegstrecke);
                element.setTechnicalCheckDistance(mileage.createMileageType(locale));
            }
            if (sd65.getNextBremsfluessigkeitsDate() != null) {
                element.setBreakFluidDate(KeyDataHelper.retrieveXMLGregorianCalendar(sd65.getNextBremsfluessigkeitsDate(), timeZone));
            }
        }
        catch (GKIException e) {
            throw e;
        }
        catch (Exception e) {
            String message = "Dates createDates XML failure";
            XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
            log.fatal((Object)("error code: " + be.getErrorCode() + " " + message));
            throw be;
        }
        return element;
    }
}

