/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.xsd;

import com.bmw.gki.ka.exception.GKIException;
import com.bmw.gki.klib.api.exception.XMLBearbeitungsException;
import com.bmw.gki.klib.api_current.DescriptionType;
import com.bmw.gki.klib.api_current.impl.DescriptionTypeImpl;
import com.bmw.gki.klib.data.orderbase.BOSAWPosition;
import com.bmw.gki.klib.temp.Beschreibung;
import com.bmw.gki.logging.GKILogManager;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.w3c.dom.Node;

public class Description {
    private static final Log LOG = GKILogManager.getInstance().getLogger(Description.class);
    public static final String CLASS_NAME = "Description";
    public static final String TAG_DESCRIPTION = "description";
    public static final String ATT_LANGUAGE = "language";
    private String language = null;
    private String description = null;

    public Description(Node node) throws GKIException {
        this.read(node);
    }

    public Description(String description, String language) {
        this.setDescription(description);
        this.setLanguage(language);
    }

    public Description(BOSAWPosition bosAwPositon, Locale locale) throws GKIException {
        if (bosAwPositon != null) {
            StringBuffer language = new StringBuffer(locale.getLanguage());
            if (locale.getCountry() != null) {
                language.append("-").append(locale.getCountry());
            }
            this.setLanguage(language.toString());
            this.setDescription(bosAwPositon.getBosBezeichnung(locale));
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Beschreibung createBeschreibung() throws GKIException {
        Beschreibung beschreibung = null;
        try {
            beschreibung = new Beschreibung();
            beschreibung.setBezeichnung(this.getDescription());
            beschreibung.setLanguage(this.getLanguage());
        }
        catch (Exception e) {
            String message = "Description createBeschreibung  XML failure";
            XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
            LOG.fatal((Object)("error code: " + be.getErrorCode() + " " + message));
            throw be;
        }
        return beschreibung;
    }

    public DescriptionType createDesriptionType() {
        DescriptionTypeImpl element = new DescriptionTypeImpl();
        try {
            if (this.getLanguage() != null) {
                element.setLanguage(this.getLanguage());
            }
            if (this.getDescription() != null) {
                element.setValue(this.getDescription());
            }
        }
        catch (Exception e) {
            String message = "Description createDescriptionType XML failure";
            XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
            LOG.fatal((Object)("error code: " + be.getErrorCode() + " " + message), (Throwable)e);
            throw be;
        }
        return element;
    }

    private void read(Node node) throws GKIException {
        try {
            this.language = node.getAttributes().getNamedItem(ATT_LANGUAGE).getNodeValue();
            if (node.getFirstChild() != null && node.getFirstChild().getNodeType() == 3) {
                this.description = node.getFirstChild().getNodeValue();
            }
        }
        catch (Exception e) {
            String message = "Description read Node - XML failure";
            XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
            LOG.fatal((Object)("error code: " + be.getErrorCode() + " " + message), (Throwable)e);
            throw be;
        }
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("Description:");
        buff.append("\nlanguage: " + this.getLanguage());
        buff.append("\ndescription: " + this.getDescription());
        return buff.toString();
    }
}

